/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.crypt;

import de.mhus.lib.core.MMath;
import de.mhus.lib.core.crypt.CipherBlock;

public class CipherBlockRotate
implements CipherBlock {
    private byte[] block;
    private int pos;

    public CipherBlockRotate(int size) {
        this.block = new byte[size];
    }

    public byte[] getBlock() {
        return this.block;
    }

    public int getSize() {
        return this.block.length;
    }

    @Override
    public void reset() {
        this.pos = 0;
    }

    @Override
    public byte encode(byte in) {
        in = MMath.rotl(in, (int)this.block[this.pos]);
        this.next();
        return in;
    }

    @Override
    public byte decode(byte in) {
        in = MMath.rotr(in, (int)this.block[this.pos]);
        this.next();
        return in;
    }

    private void next() {
        this.pos = (this.pos + 1) % this.block.length;
    }
}

