/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.console;

import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.console.ANSIConsole;
import de.mhus.lib.core.console.CmdConsole;
import de.mhus.lib.core.console.Console;
import de.mhus.lib.core.console.ConsoleFactory;
import de.mhus.lib.core.console.SimpleConsole;
import de.mhus.lib.core.console.XTermConsole;
import de.mhus.lib.core.logging.MLogUtil;

public class DefaultConsoleFactory
implements ConsoleFactory {
    @Override
    public Console create() {
        try {
            if (MSystem.isWindows()) {
                return new CmdConsole();
            }
            String term = System.getenv("TERM");
            if (term != null) {
                if ((term = term.toLowerCase()).indexOf("xterm") >= 0) {
                    return new XTermConsole();
                }
                if (term.indexOf("ansi") >= 0) {
                    return new ANSIConsole();
                }
            }
        }
        catch (Throwable t) {
            MLogUtil.log().d(t);
        }
        return new SimpleConsole();
    }
}

