/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.config;

import de.mhus.lib.core.MFile;
import de.mhus.lib.core.config.JsonConfig;
import de.mhus.lib.errors.MException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class JsonConfigFile
extends JsonConfig {
    private static final long serialVersionUID = 1L;
    private File file;

    public JsonConfigFile(File file) throws Exception {
        super(MFile.readFile(file));
        this.file = file;
    }

    public JsonConfigFile(InputStream is) throws Exception {
        super(MFile.readFile(new InputStreamReader(is, "UTF-8")));
        this.file = null;
    }

    public boolean canSave() {
        return this.file != null && this.file.canWrite();
    }

    public void save() throws MException {
        try {
            if (!this.canSave()) {
                return;
            }
            this.log().t("save config", this);
            FileOutputStream os = new FileOutputStream(this.file);
            this.write(os);
            os.close();
        }
        catch (Exception e) {
            throw new MException(new Object[]{e});
        }
    }

    @Override
    public String toString() {
        return this.getClass() + ": " + (this.file == null ? "?" : this.file.getAbsolutePath());
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getFile() {
        return this.file;
    }
}

