/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.config;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MCollection;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.config.IFlatConfig;
import de.mhus.lib.errors.MException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class EmptyConfig
extends IConfig
implements IFlatConfig {
    private static final long serialVersionUID = 1L;
    protected Properties properties = new Properties();
    protected boolean changed = false;
    protected String name;

    public EmptyConfig() {
    }

    public EmptyConfig(String fill) {
        this.properties = new Properties();
        if (fill != null) {
            try {
                this.readConfig(new StringReader(fill));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void writeConfig(Writer os) throws IOException {
        this.properties.store(os, "");
        this.changed = false;
    }

    public void readConfig(Reader file) throws IOException {
        this.properties.load(file);
    }

    public void configRemoved() {
    }

    @Override
    public IConfig getNode(String key) {
        return null;
    }

    @Override
    public List<IConfig> getNodes(String key) {
        return MCollection.getEmptyList();
    }

    @Override
    public List<IConfig> getNodes() {
        return MCollection.getEmptyList();
    }

    public List<String> getNodeKeys() {
        return MCollection.getEmptyList();
    }

    public List<String> getPropertyKeys() {
        LinkedList<String> out = new LinkedList<String>();
        for (Object key : this.properties.keySet()) {
            out.add(key.toString());
        }
        return out;
    }

    @Override
    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    @Override
    public boolean isProperty(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public void removeProperty(String key) {
        this.properties.remove(key);
        this.changed = true;
    }

    @Override
    public void setProperty(String key, Object value) {
        this.properties.setProperty(key, MCast.objectToString(value));
        this.changed = true;
    }

    public boolean isConfigChanged() {
        return this.changed;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public IConfig createConfig(String key) throws MException {
        throw new MException(new Object[]{"not supported"});
    }

    @Override
    public int moveConfig(IConfig config, int newPos) throws MException {
        throw new MException(new Object[]{"not supported"});
    }

    @Override
    public void removeConfig(IConfig config) throws MException {
        throw new MException(new Object[]{"not supported"});
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    public IConfig getParent() {
        return null;
    }

    @Override
    public InputStream getInputStream(String key) {
        return null;
    }

    @Override
    public URL getUrl() {
        return null;
    }

    @Override
    public void clear() {
    }
}

