/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.concurrent;

import de.mhus.lib.errors.TimeoutException;
import de.mhus.lib.errors.TimeoutRuntimeException;
import java.io.Closeable;

public interface Lock
extends Closeable {
    public Lock lock();

    default public Lock lockWithException(long timeout) throws TimeoutException {
        if (this.lock(timeout)) {
            return this;
        }
        throw new TimeoutException(new Object[]{this.getName()});
    }

    public boolean lock(long var1);

    default public void lock(Runnable task) {
        try (Lock lock = this.lock();){
            task.run();
        }
    }

    default public void lock(Runnable task, long timeout) throws TimeoutException {
        try (Lock lock = this.lockWithException(timeout);){
            task.run();
        }
    }

    public boolean unlock();

    default public boolean release() {
        return this.unlock();
    }

    public void unlockHard();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void waitUntilUnlock() {
        Lock lock = this;
        synchronized (lock) {
            while (this.isLocked()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    default public void waitWithException(long timeout) {
        if (this.waitUntilUnlock(timeout)) {
            return;
        }
        throw new TimeoutRuntimeException(new Object[]{this.getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean waitUntilUnlock(long timeout) {
        Lock lock = this;
        synchronized (lock) {
            while (this.isLocked()) {
                long start = System.currentTimeMillis();
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - start < timeout) continue;
                return false;
            }
            return true;
        }
    }

    public boolean isLocked();

    public String getName();

    public String getOwner();

    public long getLockTime();

    @Override
    default public void close() {
        this.unlock();
    }

    public boolean refresh();

    public long getCnt();

    public String getStartStackTrace();
}

