/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.cfg;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.logging.MLogUtil;
import java.util.function.Consumer;

public abstract class CfgValue<T> {
    private String path;
    private T def;
    private T value;
    private String owner;
    private Consumer<T> updateAction;
    private long updated = 0L;
    private String calling;

    public CfgValue(Object owner, String path, T def) {
        this.owner = owner instanceof Class ? ((Class)owner).getCanonicalName() : String.valueOf(owner);
        this.path = path;
        this.def = def;
        MApi.getCfgUpdater().register(this);
        this.update();
        this.calling = MSystem.findCalling(4);
    }

    public T value() {
        return this.value == null ? this.def : this.value;
    }

    public String getPath() {
        return this.path;
    }

    public String getOwner() {
        return this.owner;
    }

    public T getDefault() {
        return this.def;
    }

    void update() {
        T newValue = this.loadValue();
        if (MSystem.equals(this.value, newValue)) {
            return;
        }
        this.onPreUpdate(newValue);
        this.value = newValue;
        this.updated = System.currentTimeMillis();
        try {
            this.onPostUpdate(this.value);
        }
        catch (Throwable t) {
            MLogUtil.log().d(this, t);
        }
    }

    protected abstract T loadValue();

    protected abstract T loadValue(String var1);

    protected void onPreUpdate(T newValue) {
    }

    protected void onPostUpdate(T newValue) {
        if (this.updateAction != null) {
            this.updateAction.accept(newValue);
        }
    }

    public boolean isOwner(Class<?> name) {
        return this.owner.equals(name.getCanonicalName());
    }

    public boolean isOwner(String name) {
        return this.owner.equals(name);
    }

    public void setValue(String v) {
        T newValue = this.loadValue(v);
        if (newValue == null) {
            return;
        }
        if (MSystem.equals(this.value, newValue)) {
            return;
        }
        this.onPreUpdate(newValue);
        this.value = newValue;
        this.onPostUpdate(this.value);
    }

    public String toString() {
        return String.valueOf(this.value());
    }

    public boolean equals(Object in) {
        if (in != null && in instanceof CfgValue) {
            return MSystem.equals(this.value(), ((CfgValue)in).value());
        }
        return MSystem.equals(this.value(), in);
    }

    public <C extends CfgValue<T>> C updateAction(Consumer<T> consumer) {
        this.updateAction = consumer;
        return (C)this;
    }

    public long getUpdated() {
        return this.updated;
    }

    public String getCalling() {
        return this.calling;
    }
}

