/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.basics.Named;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.MThreadPool;
import de.mhus.lib.core.lang.Checker;
import de.mhus.lib.core.lang.MObject;
import de.mhus.lib.core.lang.Value;
import de.mhus.lib.core.lang.ValueProvider;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.MLogUtil;
import de.mhus.lib.errors.TimeoutRuntimeException;

public class MThread
extends MObject
implements Runnable {
    protected static Log log = Log.getLog(MThread.class);
    protected Runnable task = this;
    protected String name = null;
    protected Thread thread = null;
    private int priority = -1;
    private static ThreadGroup group = new ThreadGroup("MThread");

    public MThread() {
    }

    public MThread(String _name) {
        this.name = _name;
    }

    public MThread(Runnable _task) {
        this.task = _task;
    }

    public MThread(Runnable _task, String _name) {
        this.task = _task;
        this.name = _name;
    }

    protected Runnable getTask() {
        return this.task;
    }

    @Override
    public void run() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MThread start() {
        MThread mThread = this;
        synchronized (mThread) {
            if (this.thread != null) {
                throw new IllegalThreadStateException();
            }
            Container container = new Container();
            this.thread = new Thread(this.getGroup(), container);
            this.initThread(this.thread);
            this.thread.start();
        }
        return this;
    }

    protected ThreadGroup getGroup() {
        return group;
    }

    protected void initThread(Thread thread) {
        if (this.priority != -1) {
            thread.setPriority(this.priority);
        }
        if (this.name == null) {
            this.name = this.task == null ? "null" : (this.task instanceof Named ? "MThread " + ((Named)this.task).getName() : "MThread " + MSystem.getCanonicalClassName(this.task.getClass()));
        }
        thread.setName(this.name);
    }

    public void setName(String _name) {
        this.name = _name;
        if (this.thread != null) {
            this.thread.setName(_name);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setPriority(int _p) {
        this.priority = _p;
        if (this.thread != null) {
            this.thread.setPriority(_p);
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void stop() {
        if (this.thread == null) {
            return;
        }
        this.thread.stop();
    }

    public void interupt() {
        if (this.thread == null) {
            return;
        }
        this.thread.interrupt();
    }

    @Override
    public String toString() {
        if (this.thread != null) {
            return MSystem.toString("MThread", new Object[]{this.name, this.thread.getId(), this.thread.getPriority(), this.thread.getState()});
        }
        return MSystem.toString("MThread", this.name);
    }

    public static void sleep(long _millisec) {
        try {
            Thread.sleep(_millisec);
        }
        catch (InterruptedException e) {
            log.i(e);
        }
    }

    protected void taskError(Throwable t) {
        this.log().e(this.name, t);
    }

    public static void asynchron(Runnable task) {
        new MThread(task).start();
    }

    public static <T> T getWithTimeout(ValueProvider<T> provider, long timeout, boolean nullAllowed) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                T val = provider.getValue();
                if (nullAllowed || val != null) {
                    return val;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (System.currentTimeMillis() - start > timeout) {
                throw new TimeoutRuntimeException(new Object[0]);
            }
            MThread.sleep(200L);
        }
    }

    public static <T> T getAsynchronWithTimeout(final ValueProvider<T> provider, final long timeout, final boolean nullAllowed) {
        final long start = System.currentTimeMillis();
        final Value value = new Value();
        MThreadPool t = new MThreadPool(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Object val = provider.getValue();
                        if (nullAllowed || val != null) {
                            value.value = val;
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() - start > timeout) {
                        throw new TimeoutRuntimeException(new Object[0]);
                    }
                    MThread.sleep(200L);
                }
            }
        });
        t.start();
        while (t.isAlive()) {
            if (System.currentTimeMillis() - start > timeout) {
                throw new TimeoutRuntimeException(new Object[0]);
            }
            MThread.sleep(200L);
        }
        return value.value;
    }

    public static <T> T getAsynchronWithTimeout(final ValueProvider<T> provider, long timeout) throws Exception {
        long start = System.currentTimeMillis();
        final Value value = new Value();
        final Value error = new Value();
        MThreadPool t = new MThreadPool(new Runnable(){

            @Override
            public void run() {
                try {
                    value.value = provider.getValue();
                }
                catch (Throwable t) {
                    error.value = t;
                }
            }
        });
        t.start();
        while (t.isAlive()) {
            if (System.currentTimeMillis() - start > timeout) {
                throw new TimeoutRuntimeException(new Object[0]);
            }
            MThread.sleep(200L);
        }
        if (error.value != null) {
            if (error.value instanceof RuntimeException) {
                throw (RuntimeException)error.value;
            }
            if (error.value instanceof Exception) {
                throw (Exception)error.value;
            }
            throw new Exception((Throwable)error.value);
        }
        return value.value;
    }

    public static void waitFor(Checker checker, long timeout) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                if (checker.check()) {
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (System.currentTimeMillis() - start > timeout) {
                throw new TimeoutRuntimeException(new Object[0]);
            }
            MThread.sleep(200L);
        }
    }

    public static void waitForWithException(Checker checker, long timeout) throws Exception {
        long start = System.currentTimeMillis();
        while (!checker.check()) {
            if (System.currentTimeMillis() - start > timeout) {
                throw new TimeoutRuntimeException(new Object[0]);
            }
            MThread.sleep(200L);
        }
        return;
    }

    public Thread getThread() {
        return this.thread;
    }

    private class Container
    implements Runnable {
        private long parentThreadId;
        private String trailConfig;

        public Container() {
            try {
                this.parentThreadId = Thread.currentThread().getId();
                this.trailConfig = MLogUtil.getTrailConfig();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            try {
                if (this.trailConfig != null) {
                    MLogUtil.setTrailConfig(this.trailConfig);
                }
                MThread.this.log().t("###: NEW THREAD", this.parentThreadId, MThread.this.thread.getId());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (MThread.this.task != null) {
                    MThread.this.task.run();
                }
            }
            catch (Throwable t) {
                MThread.this.taskError(t);
            }
            try {
                log.t("###: LEAVE THREAD", MThread.this.thread.getId());
                MLogUtil.releaseTrailConfig();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

