/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.logging.Log;
import de.mhus.lib.errors.MRuntimeException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class MLdap {
    private static final Log log = Log.getLog(MLdap.class);
    public static final String KEY_NAME = ".name";
    public static final String KEY_FQDN = ".fqdn";
    public static final String KEY_CLASS = ".class";
    public static final String FILTER_ALL_CLASSES = "(objectclass=*)";

    public static DirContext getConnection(String url, String principal, String password) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", url);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", principal);
        env.put("java.naming.security.credentials", password);
        InitialDirContext ctx = new InitialDirContext(env);
        return ctx;
    }

    public static SearchControls getSimpleSearchControls() {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setTimeLimit(30000);
        return searchControls;
    }

    public static Map<String, Object> resultToMap(SearchResult result) throws NamingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        NamingEnumeration<? extends Attribute> attrs = result.getAttributes().getAll();
        while (attrs.hasMore()) {
            Attribute attr = attrs.next();
            String attrId = attr.getID();
            if (attr.size() > 1) {
                LinkedList<String> list = new LinkedList<String>();
                for (int i = 0; i < attr.size(); ++i) {
                    String attrValue = String.valueOf(attr.get(i));
                    list.add(attrValue);
                }
                map.put(attrId, list);
                continue;
            }
            String attrValue = String.valueOf(attr.get());
            map.put(attrId, attrValue);
        }
        map.put(KEY_NAME, result.getName());
        map.put(KEY_FQDN, result.getNameInNamespace());
        map.put(KEY_CLASS, result.getClassName());
        return map;
    }

    public static Map<String, Object> getFirst(NamingEnumeration<SearchResult> res) {
        try {
            Map<String, Object> next = MLdap.getNext(res);
            res.close();
            return next;
        }
        catch (Exception t) {
            throw new MRuntimeException(new Object[]{t});
        }
    }

    public static Map<String, Object> getNext(NamingEnumeration<SearchResult> res) {
        try {
            if (!res.hasMore()) {
                return null;
            }
            SearchResult result = res.next();
            return MLdap.resultToMap(result);
        }
        catch (Exception t) {
            throw new MRuntimeException(new Object[]{t});
        }
    }

    public static Iterable<Map<String, Object>> iterate(final NamingEnumeration<SearchResult> res) {
        return new Iterable<Map<String, Object>>(){

            @Override
            public Iterator<Map<String, Object>> iterator() {
                return new Iterator<Map<String, Object>>(){

                    @Override
                    public boolean hasNext() {
                        try {
                            return res.hasMore();
                        }
                        catch (Exception t) {
                            throw new MRuntimeException(new Object[]{t});
                        }
                    }

                    @Override
                    public Map<String, Object> next() {
                        try {
                            SearchResult result = (SearchResult)res.next();
                            Map<String, Object> map = MLdap.resultToMap(result);
                            return map;
                        }
                        catch (Exception t) {
                            throw new MRuntimeException(new Object[]{t});
                        }
                    }
                };
            }
        };
    }

    public static List<String> getNames(NamingEnumeration<SearchResult> res) {
        LinkedList<String> out = new LinkedList<String>();
        try {
            while (res.hasMore()) {
                SearchResult result = res.next();
                out.add(result.getName());
            }
        }
        catch (Exception t) {
            throw new MRuntimeException(new Object[]{t});
        }
        return out;
    }

    public static List<String> getFQDNs(NamingEnumeration<SearchResult> res) {
        LinkedList<String> out = new LinkedList<String>();
        try {
            while (res.hasMore()) {
                SearchResult result = res.next();
                out.add(result.getNameInNamespace());
            }
        }
        catch (Exception t) {
            throw new MRuntimeException(new Object[]{t});
        }
        return out;
    }
}

