/**
 * Copyright 2018 Mike Hummel
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.mhus.lib.core.util;

import java.util.ListIterator;

import de.mhus.lib.basics.ReadOnly;

public class EmptyListOperator<E> implements ListIterator<E>, ReadOnly {

	@Override
	public boolean hasNext() {
		return false;
	}

	@Override
	public E next() {
		return null;
	}

	@Override
	public boolean hasPrevious() {
		return false;
	}

	@Override
	public E previous() {
		return null;
	}

	@Override
	public int nextIndex() {
		return -1;
	}

	@Override
	public int previousIndex() {
		return -1;
	}

	@Override
	public void remove() {
	}

	@Override
	public void set(E e) {
	}

	@Override
	public void add(E e) {
	}

}
