/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SoftHashMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap<K, SoftReference<V>> map = new HashMap();
    private long lastCleanup;

    public SoftHashMap() {
    }

    private SoftHashMap(HashMap<K, SoftReference<V>> map) {
        this.map = map;
    }

    private void periodicCleanup() {
        if (System.currentTimeMillis() - this.lastCleanup < 60000L) {
            return;
        }
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        HashMap<K, SoftReference<V>> hashMap = this.map;
        synchronized (hashMap) {
            Iterator<Map.Entry<K, SoftReference<V>>> iter = this.map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<K, SoftReference<V>> entry = iter.next();
                if (entry.getValue() != null && entry.getValue().get() != null) continue;
                iter.remove();
            }
            this.lastCleanup = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        HashMap<K, SoftReference<V>> hashMap = this.map;
        synchronized (hashMap) {
            return this.map.equals(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.periodicCleanup();
        HashMap<K, SoftReference<V>> hashMap = this.map;
        synchronized (hashMap) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.periodicCleanup();
        HashMap<K, SoftReference<V>> hashMap = this.map;
        synchronized (hashMap) {
            return this.map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        this.periodicCleanup();
        HashMap<K, SoftReference<V>> hashMap = this.map;
        synchronized (hashMap) {
            SoftReference<V> s = this.map.get(key);
            if (s == null) {
                return null;
            }
            V v = s.get();
            if (v == null) {
                this.map.remove(key);
                return null;
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        HashMap<K, SoftReference<V>> hashMap = this.map;
        synchronized (hashMap) {
            return this.map.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        this.periodicCleanup();
        HashMap<K, SoftReference<V>> hashMap = this.map;
        synchronized (hashMap) {
            return this.map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        HashMap<K, SoftReference<V>> hashMap = this.map;
        synchronized (hashMap) {
            return this.map.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        this.periodicCleanup();
        HashMap<K, SoftReference<V>> hashMap = this.map;
        synchronized (hashMap) {
            SoftReference<V> s = this.map.put(key, new SoftReference<V>(value));
            if (s == null) {
                return null;
            }
            return s.get();
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        this.periodicCleanup();
        HashMap<K, SoftReference<V>> hashMap = this.map;
        synchronized (hashMap) {
            SoftReference<V> s = this.map.remove(key);
            if (s == null) {
                return null;
            }
            return s.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        HashMap<K, SoftReference<V>> hashMap = this.map;
        synchronized (hashMap) {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        this.periodicCleanup();
        HashMap<K, SoftReference<V>> hashMap = this.map;
        synchronized (hashMap) {
            return this.map.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        this.cleanup();
        HashMap<K, SoftReference<V>> hashMap = this.map;
        synchronized (hashMap) {
            return new SoftHashMap<K, V>((HashMap)this.map.clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        this.periodicCleanup();
        HashMap<K, SoftReference<V>> hashMap = this.map;
        synchronized (hashMap) {
            return this.map.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        this.periodicCleanup();
        HashMap<K, SoftReference<V>> hashMap = this.map;
        synchronized (hashMap) {
            return new CollectionWrap(this.map.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.periodicCleanup();
        HashMap<K, SoftReference<V>> hashMap = this.map;
        synchronized (hashMap) {
            return new EntrySetWrap(this.map.entrySet());
        }
    }

    private class IteratorWrap
    implements Iterator<V> {
        private Iterator<SoftReference<V>> iterator;

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            return this.iterator.next().get();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        public IteratorWrap(Iterator<SoftReference<V>> iterator) {
            this.iterator = iterator;
        }
    }

    private class CollectionWrap
    implements Collection<V> {
        private Collection<SoftReference<V>> col;

        @Override
        public int size() {
            return this.col.size();
        }

        @Override
        public boolean isEmpty() {
            return this.col.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.col.contains(o);
        }

        @Override
        public Iterator<V> iterator() {
            return new IteratorWrap(this.col.iterator());
        }

        @Override
        public Object[] toArray() {
            return this.col.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.col.toArray(a);
        }

        @Override
        public boolean add(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            return this.col.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.col.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends V> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.col.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.col.retainAll(c);
        }

        @Override
        public void clear() {
            this.col.clear();
        }

        @Override
        public boolean equals(Object o) {
            return this.col.equals(o);
        }

        @Override
        public int hashCode() {
            return this.col.hashCode();
        }

        public CollectionWrap(Collection<SoftReference<V>> col) {
            this.col = col;
        }
    }

    private class MapEntryWrap
    implements Map.Entry<K, V> {
        private Map.Entry<K, SoftReference<V>> next;

        @Override
        public K getKey() {
            return this.next.getKey();
        }

        @Override
        public V getValue() {
            return this.next.getValue().get();
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            return this.next.equals(o);
        }

        @Override
        public int hashCode() {
            return this.next.hashCode();
        }

        public MapEntryWrap(Map.Entry<K, SoftReference<V>> next) {
            this.next = next;
        }
    }

    private class MapIteratorWrap
    implements Iterator<Map.Entry<K, V>> {
        private Iterator<Map.Entry<K, SoftReference<V>>> itertor;

        @Override
        public boolean hasNext() {
            return this.itertor.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            return new MapEntryWrap(this.itertor.next());
        }

        @Override
        public void remove() {
            this.itertor.remove();
        }

        public MapIteratorWrap(Iterator<Map.Entry<K, SoftReference<V>>> iterator) {
            this.itertor = iterator;
        }
    }

    private class EntrySetWrap
    implements Set<Map.Entry<K, V>> {
        private Set<Map.Entry<K, SoftReference<V>>> set;

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.set.contains(o);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new MapIteratorWrap(this.set.iterator());
        }

        @Override
        public Object[] toArray() {
            return this.set.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.set.toArray(a);
        }

        @Override
        public boolean add(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            return this.set.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.set.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.set.retainAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.set.removeAll(c);
        }

        @Override
        public void clear() {
            this.set.clear();
        }

        @Override
        public boolean equals(Object o) {
            return this.set.equals(o);
        }

        @Override
        public int hashCode() {
            return this.set.hashCode();
        }

        public EntrySetWrap(Set<Map.Entry<K, SoftReference<V>>> entrySet) {
            this.set = entrySet;
        }
    }
}

