/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.system;

import de.mhus.lib.core.MFile;
import de.mhus.lib.core.cfg.CfgInitiator;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.service.ServerIdent;
import de.mhus.lib.core.system.CfgManager;
import de.mhus.lib.core.system.IApiInternal;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class DockerInitializer
implements CfgInitiator {
    private static String containerId;

    @Override
    public void doInitialize(IApiInternal internal, CfgManager manager, IConfig config) {
        File cgroup = new File("/proc/self/cgroup");
        if (cgroup.exists()) {
            try {
                List<String> content = MFile.readLines(cgroup, true);
                for (String line : content) {
                    if (!line.contains(":memory:")) continue;
                    String[] parts = line.split("/");
                    if (parts.length > 2) {
                        containerId = parts[2];
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (containerId != null) {
            System.out.println("Container: " + containerId);
            ServerIdent.getAttributes().setString("containerId", containerId);
            ServerIdent.getAttributes().setString("containerShortId", containerId.substring(0, 12));
        } else {
            System.out.println("WARNING: docker environment not found");
        }
    }

    public static String getContainerId() {
        return containerId;
    }
}

