/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.service;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MMath;
import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.cfg.CfgBoolean;
import de.mhus.lib.core.cfg.CfgString;
import de.mhus.lib.core.lang.MObject;
import de.mhus.lib.core.parser.StringCompiler;
import de.mhus.lib.errors.MException;
import java.io.File;
import java.util.UUID;

public class ServerIdent
extends MObject {
    private CfgString CFG_IDENT = new CfgString(ServerIdent.class, "ident", null){

        @Override
        protected void onPostUpdate(String newValue) {
            super.onPostUpdate(newValue);
            ServerIdent.this.update();
        }
    };
    private CfgString CFG_PATTERN = new CfgString(ServerIdent.class, "pattern", "$#hostname$-$time$$random$"){

        @Override
        protected void onPostUpdate(String newValue) {
            super.onPostUpdate(newValue);
            ServerIdent.this.update();
        }
    };
    private CfgBoolean CFG_PERSISTENT = new CfgBoolean((Object)ServerIdent.class, "persistent", true);
    private static MProperties ATTRIBUTES = new MProperties();
    private String ident = null;

    public ServerIdent() {
        this.update();
    }

    public static MProperties getAttributes() {
        return ATTRIBUTES;
    }

    private synchronized void update() {
        if (this.CFG_IDENT == null || this.CFG_PATTERN == null || this.CFG_PERSISTENT == null) {
            return;
        }
        this.ident = (String)this.CFG_IDENT.value();
        if (this.ident == null) {
            String persistence = MApi.getCfg(ServerIdent.class).getString("persistence", MApi.getFile(MApi.SCOPE.ETC, ServerIdent.class.getCanonicalName() + ".properties").getAbsolutePath());
            File file = new File(persistence);
            String def = null;
            if (((Boolean)this.CFG_PERSISTENT.value()).booleanValue() && file.exists() && file.isFile()) {
                ATTRIBUTES = MProperties.load(file);
                def = ATTRIBUTES.getString("default", null);
            }
            if (def == null) {
                try {
                    def = this.create();
                    ATTRIBUTES.setString("default", def);
                    if (((Boolean)this.CFG_PERSISTENT.value()).booleanValue()) {
                        ATTRIBUTES.save(file);
                    }
                }
                catch (Exception e) {
                    this.log().e(e);
                }
            }
            this.ident = def = MFile.normalize(def);
        }
    }

    private String create() throws MException {
        String created = StringCompiler.compile((String)this.CFG_PATTERN.value()).execute(ATTRIBUTES);
        return created;
    }

    @Override
    public String toString() {
        return this.ident;
    }

    static {
        ATTRIBUTES.setString("random", String.valueOf(MMath.toBasis36((long)(Math.random() * 36.0 * 36.0 * 36.0 * 36.0), 4)));
        ATTRIBUTES.setString("time", String.valueOf(MMath.toBasis36(System.currentTimeMillis(), 4)));
        ATTRIBUTES.setString("uuid", UUID.randomUUID().toString());
    }
}

