/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.lang;

import de.mhus.lib.core.lang.AlreadyBoundException;
import java.util.Arrays;
import java.util.HashMap;

public class LocalClassLoader
extends ClassLoader {
    private HashMap<String, byte[]> localCode = new HashMap();
    private HashMap<String, Class<?>> localClasses = new HashMap();

    public LocalClassLoader() {
    }

    public LocalClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.localClasses.get(name);
        if (clazz != null) {
            return clazz;
        }
        byte[] code = this.localCode.get(name);
        if (code != null) {
            clazz = this.defineClass(name, code, 0, code.length);
            if (resolve) {
                this.resolveClass(clazz);
            }
            this.localClasses.put(name, clazz);
        }
        if (clazz != null) {
            return clazz;
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.localClasses.get(name);
        if (clazz != null) {
            return clazz;
        }
        byte[] code = this.localCode.get(name);
        if (code != null) {
            clazz = this.defineClass(name, code, 0, code.length);
            this.resolveClass(clazz);
            this.localClasses.put(name, clazz);
        }
        if (clazz != null) {
            return clazz;
        }
        return super.findClass(name);
    }

    public void addClassCode(String name, byte[] code) throws AlreadyBoundException {
        if (this.localClasses.containsKey(name)) {
            throw new AlreadyBoundException(name);
        }
        this.localCode.put(name, Arrays.copyOf(code, code.length));
    }

    public void removeClassCode(String name) {
        this.localCode.remove(name);
        this.localClasses.remove(name);
    }
}

