/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.crypt;

import de.mhus.lib.core.M;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MPeriod;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.MThread;
import de.mhus.lib.core.cfg.CfgInt;
import de.mhus.lib.core.cfg.CfgLong;
import de.mhus.lib.core.crypt.MRandom;
import de.mhus.lib.core.crypt.pem.PemBlock;
import de.mhus.lib.core.crypt.pem.PemBlockModel;
import de.mhus.lib.core.crypt.pem.PemUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.LinkedList;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class MBouncy {
    protected static final String ALGORITHM_RSA = "RSA";
    protected static final String PROVIDER = "BC";
    protected static final String TRANSFORMATION = "RSA/ECB/PKCS1Padding";
    protected static final String ALGORITHM_AES = "AES";
    private static final Charset STRING_ENCODING = MString.CHARSET_CHARSET_UTF_8;
    public static final RSA_KEY_SIZE RSA_KEY_SIZE_DEFAULT = RSA_KEY_SIZE.B1024;
    private static final String TRANSFORMATION_ECC = "SHA512WITHECDSA";
    private static final String ALGORITHM_ECC = "ECDSA";
    private static LinkedList<KeyPair> keyPool = new LinkedList();
    private static long keyPoolUpdate = 0L;
    private static CfgLong CFG_POOL_UPDATE_TIME = new CfgLong((Object)MBouncy.class, "poolUpdateTime", 600000L);
    private static CfgInt CFG_POOL_SIZE = new CfgInt((Object)MBouncy.class, "poolSize", 10);

    public static void init() {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static KeyPair generateRsaKey(RSA_KEY_SIZE size) throws NoSuchAlgorithmException, NoSuchProviderException {
        MBouncy.init();
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(ALGORITHM_RSA, PROVIDER);
        keyGen.initialize(size.getBits());
        KeyPair key = keyGen.generateKeyPair();
        return key;
    }

    public static PublicKey getPublicKey(String key) {
        try {
            MBouncy.init();
            byte[] encodedKey = MBouncy.decodeBase64(key);
            X509EncodedKeySpec encodedKeySpec = new X509EncodedKeySpec(encodedKey);
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_RSA, PROVIDER);
            return keyFactory.generatePublic(encodedKeySpec);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public static PrivateKey getPrivateKey(String key) {
        try {
            MBouncy.init();
            byte[] encodedKey = MBouncy.decodeBase64(key);
            PKCS8EncodedKeySpec encodedKeySpec = new PKCS8EncodedKeySpec(encodedKey);
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_RSA, PROVIDER);
            return keyFactory.generatePrivate(encodedKeySpec);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getPublicKey(KeyPair key) {
        return MBouncy.encodeBase64(new X509EncodedKeySpec(key.getPublic().getEncoded()).getEncoded());
    }

    public static String getPrivateKey(KeyPair key) {
        return MBouncy.encodeBase64(new PKCS8EncodedKeySpec(key.getPrivate().getEncoded()).getEncoded());
    }

    public static PemBlock getPrivatePem(KeyPair pair) {
        PrivateKey key = pair.getPrivate();
        return MBouncy.getPrivatePem(key);
    }

    public static PemBlock getPrivatePem(PrivateKey key) {
        PemBlockModel pem = new PemBlockModel("PRIVATE KEY");
        pem.setString("Method", key.getAlgorithm());
        pem.setString("Format", key.getFormat());
        pem.setBlock(key.getEncoded());
        return pem;
    }

    public static PemBlock getPublicPem(KeyPair pair) {
        PublicKey key = pair.getPublic();
        return MBouncy.getPublicPem(key);
    }

    public static PemBlock getPublicPem(PublicKey key) {
        PemBlockModel pem = new PemBlockModel("PUBLIC KEY");
        pem.setString("Method", key.getAlgorithm());
        pem.setString("Format", key.getFormat());
        pem.setBlock(key.getEncoded());
        return pem;
    }

    public static byte[] encryptRsa117(byte[] text, PublicKey key) throws Exception {
        MBouncy.init();
        byte[] cipherText = null;
        Cipher cipher = Cipher.getInstance(TRANSFORMATION, PROVIDER);
        cipher.init(1, key);
        cipherText = cipher.doFinal(text);
        return cipherText;
    }

    public static byte[] encryptRsa(byte[] text, PublicKey key) throws Exception {
        byte[] out;
        int len;
        MBouncy.init();
        Cipher cipher = Cipher.getInstance(TRANSFORMATION, PROVIDER);
        cipher.init(1, key);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int start = 0;
        while (true) {
            if ((len = text.length - start) <= 117) break;
            out = cipher.doFinal(text, start, 117);
            os.write(out);
            start += 117;
        }
        out = cipher.doFinal(text, start, len);
        os.write(out);
        return os.toByteArray();
    }

    public static byte[] decryptRsa(byte[] text, PrivateKey key, RSA_KEY_SIZE size) throws Exception {
        MBouncy.init();
        Cipher cipher = Cipher.getInstance(TRANSFORMATION, PROVIDER);
        cipher.init(2, key);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int blockSize = size.getBlockSize();
        int start = 0;
        while (true) {
            int len;
            if ((len = text.length - start) > blockSize) {
                len = blockSize;
            }
            byte[] out = cipher.doFinal(text, start, len);
            os.write(out);
            if (start + len >= text.length) break;
            start += len;
        }
        return os.toByteArray();
    }

    public static String encryptRsa117(String text, PublicKey key) throws Exception {
        byte[] cipherText = MBouncy.encryptRsa(text.getBytes(STRING_ENCODING), key);
        String encryptedText = MBouncy.encodeBase64(cipherText);
        return encryptedText;
    }

    public static byte[] decryptRsa117(byte[] text, PrivateKey key) throws Exception {
        MBouncy.init();
        byte[] dectyptedText = null;
        Cipher cipher = Cipher.getInstance(TRANSFORMATION, PROVIDER);
        cipher.init(2, key);
        dectyptedText = cipher.doFinal(text);
        return dectyptedText;
    }

    public static String decryptRsa117(String text, PrivateKey key) throws Exception {
        MBouncy.init();
        Cipher cipher = Cipher.getInstance(TRANSFORMATION, PROVIDER);
        cipher.init(2, key);
        byte[] enc = MBouncy.decodeBase64(text);
        byte[] dectyptedText = cipher.doFinal(enc);
        String result = new String(dectyptedText, STRING_ENCODING);
        return result;
    }

    public static String encodeBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] decodeBase64(String text) {
        return Base64.getDecoder().decode(text);
    }

    public static byte[] createRandom(int size) {
        byte[] out = new byte[size];
        MRandom rnd = M.l(MRandom.class);
        for (int i = 0; i < out.length; ++i) {
            out[i] = rnd.getByte();
        }
        return out;
    }

    public static byte[] encryptAes(byte[] key, byte[] data) {
        MBouncy.init();
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM_AES, PROVIDER);
            Key skeySpec = MBouncy.generateAesKeySpec(key);
            cipher.init(1, skeySpec);
            byte[] encrypted = cipher.doFinal(data);
            return encrypted;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encryptAes(byte[] key, String data) {
        byte[] enc = MBouncy.encryptAes(key, data.getBytes(STRING_ENCODING));
        return MBouncy.encodeBase64(enc);
    }

    public static Key generateAesKeySpec(byte[] key) {
        SecretKeySpec k = new SecretKeySpec(key, ALGORITHM_AES);
        return k;
    }

    public static byte[] decryptAes(byte[] key, byte[] encrypted) {
        MBouncy.init();
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM_AES, PROVIDER);
            Key skeySpec = MBouncy.generateAesKeySpec(key);
            cipher.init(2, skeySpec);
            byte[] decrypted = cipher.doFinal(encrypted);
            return decrypted;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decryptAes(byte[] key, String encrypted) {
        byte[] dec = MBouncy.decryptAes(key, MBouncy.decodeBase64(encrypted));
        return new String(dec, STRING_ENCODING);
    }

    public static synchronized KeyPair getRsaKeyFromPool() {
        if (MPeriod.isTimeOut(keyPoolUpdate, (Long)CFG_POOL_UPDATE_TIME.value())) {
            if (keyPool.size() > 0) {
                keyPool.removeFirst();
            }
            keyPoolUpdate = System.currentTimeMillis();
        }
        if (keyPool.size() < (Integer)CFG_POOL_SIZE.value()) {
            try {
                KeyPair key = MBouncy.generateRsaKey(RSA_KEY_SIZE_DEFAULT);
                keyPool.add(key);
                return key;
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                throw new RuntimeException(e);
            }
        }
        int pos = (int)(Math.random() * (double)keyPool.size());
        return keyPool.get(pos);
    }

    public static KeyPair generateEccKey(ECC_SPEC spec) {
        MBouncy.init();
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(ALGORITHM_ECC, PROVIDER);
            MRandom random = M.l(MRandom.class);
            ECGenParameterSpec ecGenSpec = new ECGenParameterSpec(spec.name().toLowerCase());
            keyGen.initialize(ecGenSpec, random.getSecureRandom());
            KeyPair key = keyGen.generateKeyPair();
            return key;
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
    }

    public static boolean validateSignature(PublicKey key, String in, String sign) {
        try {
            return MBouncy.validateSignature(key, new ByteArrayInputStream(in.getBytes(MString.CHARSET_CHARSET_UTF_8)), sign);
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
    }

    public static boolean validateSignature(PublicKey key, InputStream is, String sign) {
        try {
            int len;
            byte[] encKey = key.getEncoded();
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(encKey);
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_ECC, PROVIDER);
            PublicKey pubKey = keyFactory.generatePublic(pubKeySpec);
            Signature sig = Signature.getInstance(TRANSFORMATION_ECC, PROVIDER);
            sig.initVerify(pubKey);
            byte[] buffer = new byte[10240];
            while ((len = is.read(buffer)) >= 0) {
                if (len == 0) {
                    MThread.sleep(200L);
                    continue;
                }
                sig.update(buffer, 0, len);
            }
            PemBlock signBlock = PemUtil.parse(sign);
            return sig.verify(signBlock.getBytesBlock());
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
    }

    public static String createSignature(PrivateKey key, String in) {
        try {
            return MBouncy.createSignature(key, new ByteArrayInputStream(in.getBytes("UTF-8")));
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
    }

    public static String createSignature(PrivateKey key, InputStream is) {
        try {
            int len;
            byte[] encKey = key.getEncoded();
            PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(encKey);
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_ECC, PROVIDER);
            PrivateKey privKey = keyFactory.generatePrivate(privKeySpec);
            Signature sig = Signature.getInstance(TRANSFORMATION_ECC, PROVIDER);
            sig.initSign(privKey);
            byte[] buffer = new byte[10240];
            while ((len = is.read(buffer)) >= 0) {
                if (len == 0) {
                    MThread.sleep(200L);
                    continue;
                }
                sig.update(buffer, 0, len);
            }
            PemBlockModel pem = new PemBlockModel("SIGNATURE", sig.sign());
            pem.setString("Method", key.getAlgorithm());
            return pem.toString();
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
    }

    public static enum ECC_SPEC {
        PRIME192V1,
        PRIME192V2,
        PRIME192V3,
        PRIME239V1,
        PRIME239V2,
        PRIME239V3,
        PRIME256V1,
        SECP192K1,
        SECP192R1,
        SECP244K1,
        SECP244R1,
        SECP256K1,
        SECP256R1,
        SECP384R1,
        SECP521R1;

    }

    public static enum RSA_KEY_SIZE {
        B1024,
        B2048,
        B4096;

        private int bits = MCast.toint(this.name().substring(1), 1024);

        public int getBits() {
            return this.bits;
        }

        public int getBlockSize() {
            return Math.max(this.getBits() / 1024 * 128, 64);
        }
    }
}

