/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.console;

import de.mhus.lib.core.console.Console;
import de.mhus.lib.core.console.ConsoleKey;
import de.mhus.lib.core.logging.MLogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import org.jline.reader.LineReader;
import org.jline.reader.impl.LineReaderImpl;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class ANSIConsole
extends Console {
    public static final int KEY_SPECIAL_LEFT = 68;
    public static final int KEY_SPECIAL_UP = 65;
    public static final int KEY_SPECIAL_DOWN = 66;
    public static final int KEY_SPECIAL_RIGHT = 67;
    public static final int KEY_ENTER = 13;
    public static final int KEY_q = 113;
    public static final int KEY_a = 97;
    public static final int KEY_z = 112;
    public static final int KEY_A = 65;
    public static final int KEY_Z = 90;
    public static final int KEY_0 = 48;
    public static final int KEY_9 = 57;
    public static final int KEY_TAB = 9;
    public static final int KEY_ESC = 27;
    public static final int KEY_CTRL_A = 1;
    public static final int KEY_CTRL_Z = 26;
    public static final int KEY_FUNCTION = 79;
    public static final int KEY_F1 = 80;
    public static final int KEY_F2 = 81;
    public static final int KEY_F3 = 82;
    public static final int KEY_F4 = 83;
    protected Console.COLOR foreground;
    protected Console.COLOR background;
    protected boolean blink;
    protected boolean bold;
    protected LineReaderImpl reader;
    protected int width = 0;
    protected int height = 0;
    protected boolean supportSize;

    public ANSIConsole() throws IOException {
        this(new LineReaderImpl(TerminalBuilder.builder().build()));
    }

    public ANSIConsole(LineReaderImpl reader) throws IOException {
        this.reader = reader;
        this.loadSettings();
    }

    @Override
    public <T> T adaptTo(Class<? extends T> clazz) {
        if (clazz == LineReader.class || clazz == LineReaderImpl.class) {
            return (T)this.reader;
        }
        return super.adaptTo(clazz);
    }

    protected void loadSettings() {
        int w = this.reader.getTerminal().getWidth();
        int h = this.reader.getTerminal().getHeight();
        if (w == 80 && h == 24) {
            this.width = DEFAULT_WIDTH;
            this.height = DEFAULT_HEIGHT;
            this.supportSize = false;
        } else {
            this.width = 0;
            this.height = 0;
            this.supportSize = true;
        }
    }

    public ANSIConsole(InputStream in, PrintStream out, boolean flush, String charset) throws IOException {
        super(out, flush, charset);
        this.reader = new LineReaderImpl(TerminalBuilder.builder().streams(in, (OutputStream)out).build());
        this.loadSettings();
    }

    public ANSIConsole(InputStream in, PrintStream out) throws IOException {
        super(out);
        this.reader = new LineReaderImpl(TerminalBuilder.builder().streams(in, (OutputStream)out).build());
        this.loadSettings();
    }

    @Override
    public String readPassword() throws IOException {
        return this.reader.readLine(Character.valueOf('*'));
    }

    @Override
    public String readLine(LinkedList<String> history) {
        try {
            return this.reader.readLine();
        }
        catch (Exception e) {
            MLogUtil.log().t(e);
            return null;
        }
    }

    @Override
    public int read() {
        try {
            return this.reader.readCharacter();
        }
        catch (Exception e) {
            MLogUtil.log().t(e);
            return -1;
        }
    }

    @Override
    public ConsoleKey readKey() {
        int first;
        while ((first = this.read()) == 1091) {
            int second = this.read();
            switch (second) {
                case 65: 
                case 66: 
                case 67: 
                case 68: {
                    return new ConsoleKey(0, true, (char)second);
                }
                case 80: 
                case 81: 
                case 82: 
                case 83: {
                    return new ConsoleKey(0, true, (char)(second - 79));
                }
            }
        }
        return new ConsoleKey(0, false, (char)first);
    }

    @Override
    public boolean isSupportSize() {
        return this.supportSize;
    }

    @Override
    public int getWidth() {
        if (this.width > 0) {
            return this.width;
        }
        return this.reader.getTerminal().getWidth();
    }

    @Override
    public int getHeight() {
        if (this.height > 0) {
            return this.height;
        }
        return this.reader.getTerminal().getHeight();
    }

    @Override
    public boolean isSupportCursor() {
        return true;
    }

    @Override
    public void setCursor(int x, int y) {
        this.print(ANSIConsole.ansiSetCursor(x, y));
    }

    public static String ansiSetCursor(int x, int y) {
        return "\u001b[" + y + ";" + x + "H";
    }

    @Override
    public int getCursorX() {
        return -1;
    }

    @Override
    public int getCursorY() {
        return -1;
    }

    @Override
    public boolean isSupportColor() {
        return this.reader.getTerminal().getType().equals("ansi");
    }

    @Override
    public void setColor(Console.COLOR foreground, Console.COLOR background) {
        this.foreground = foreground;
        this.background = background;
        if (this.isSupportColor()) {
            if (foreground != null && foreground != Console.COLOR.UNKNOWN) {
                this.print(ANSIConsole.ansiForeground(foreground));
            }
            if (background != null && background != Console.COLOR.UNKNOWN) {
                this.print(ANSIConsole.ansiBackground(background));
            }
        }
    }

    public static String ansiForeground(Console.COLOR color) {
        return "\u001b[3" + ANSIConsole.ansiColorValue(color) + "m";
    }

    public static String ansiBackground(Console.COLOR color) {
        return "\u001b[4" + ANSIConsole.ansiColorValue(color) + "m";
    }

    @Override
    public Console.COLOR getForegroundColor() {
        return this.foreground;
    }

    @Override
    public Console.COLOR getBackgroundColor() {
        return this.background;
    }

    @Override
    public boolean isSupportBlink() {
        return this.isSupportColor();
    }

    @Override
    public void setBlink(boolean blink) {
        this.blink = blink;
        this.updateAttributes();
    }

    private void updateAttributes() {
        if (this.isSupportColor()) {
            this.print(ANSIConsole.ansiAttributes(this.blink, this.bold));
        }
    }

    public static String ansiAttributes(boolean blink, boolean bold) {
        return "\u001b[0" + (blink ? ";5" : "") + (bold ? ";1" : "") + "m";
    }

    @Override
    public boolean isBlink() {
        return this.blink;
    }

    @Override
    public boolean isSupportBold() {
        return this.isSupportColor();
    }

    @Override
    public void setBold(boolean bold) {
        this.bold = bold;
        this.updateAttributes();
    }

    @Override
    public boolean isBold() {
        return this.bold;
    }

    public static String ansiColorValue(Console.COLOR col) {
        switch (col) {
            case BLACK: {
                return "0";
            }
            case BLUE: {
                return "4";
            }
            case GREEN: {
                return "2";
            }
            case RED: {
                return "1";
            }
            case WHITE: {
                return "7";
            }
            case YELLOW: {
                return "3";
            }
            case CYAN: {
                return "6";
            }
            case MAGENTA: {
                return "5";
            }
        }
        return "7";
    }

    @Override
    public void cleanup() {
        this.bold = false;
        this.blink = false;
        this.foreground = Console.COLOR.UNKNOWN;
        this.background = Console.COLOR.UNKNOWN;
        this.print(ANSIConsole.ansiCleanup());
    }

    public static String ansiCleanup() {
        return "\u001b[0m";
    }

    @Override
    public void resetTerminal() {
        this.print(ANSIConsole.ansiReset());
    }

    public static String ansiReset() {
        return "\u001bc";
    }

    @Override
    public boolean isAnsi() {
        return true;
    }

    public static String[] getRawAnsiSettings() throws IOException {
        Terminal terminal = TerminalBuilder.terminal();
        return new String[]{"Width: " + terminal.getWidth(), "Height: " + terminal.getHeight(), "Ansi: " + terminal.getType().equals("ansi"), "Echo: " + terminal.echo()};
    }

    @Override
    public void setWidth(int w) {
        this.width = w;
    }

    @Override
    public void setHeight(int h) {
        this.height = h;
    }
}

