/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.calendar;

import de.mhus.lib.core.calendar.Holidays;
import de.mhus.lib.core.util.MNls;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class GermanHolidays
extends Holidays {
    @Override
    public Map<Date, String> getHolidays(MNls nls, int year, String regionHint) {
        if (nls == null) {
            nls = new MNls();
        }
        if (regionHint == null) {
            regionHint = "";
        }
        boolean evangelic = (regionHint = regionHint.toLowerCase()).equals("evangelical") || regionHint.equals("berlin") || regionHint.equals("brandenburg") || regionHint.equals("bremen") || regionHint.equals("hamburg") || regionHint.equals("hessen") || regionHint.equals("mecklenburg-vorpommern") || regionHint.equals("mecklenburg") || regionHint.equals("vorpommern") || regionHint.equals("niedersachsen") || regionHint.equals("sachsen") || regionHint.equals("sachsen-anhalt") || regionHint.equals("schleswig-holstein") || regionHint.equals("th\u00fcringen");
        HashMap<Date, String> out = new HashMap<Date, String>();
        out.put(new Date(year - 1900, 0, 1), nls.find("newYearsDay=New Years Day"));
        out.put(new Date(year - 1900, 4, 1), nls.find("firstMay=1. May"));
        out.put(new Date(year - 1900, 9, 3), nls.find("germanUnity=Day of German Unity"));
        if (evangelic) {
            out.put(new Date(year - 1900, 9, 31), nls.find("reformationDay=Reformation Day"));
        } else {
            out.put(new Date(year - 1900, 10, 1), nls.find("allSaintsDay=All Saints' Day"));
        }
        out.put(new Date(year - 1900, 11, 25), nls.find("xmax1=1. Christmas Holiday"));
        out.put(new Date(year - 1900, 11, 26), nls.find("xmax2=2. Christmas Holiday"));
        Calendar cal = GermanHolidays.getEasterSundayDate(year);
        out.put(cal.getTime(), nls.find("easterSunday=Easter Sunday"));
        cal.add(5, -2);
        out.put(cal.getTime(), nls.find("goodFriday=Good Friday"));
        cal.add(5, 3);
        out.put(cal.getTime(), nls.find("easterMonday=Easter Monday"));
        cal.add(5, 49);
        out.put(cal.getTime(), nls.find("whitsunMonday=Whitsun Monday"));
        cal.add(5, -1);
        out.put(cal.getTime(), nls.find("whitsunSunday=Whitsun Sunday"));
        cal.add(5, -10);
        out.put(cal.getTime(), nls.find("ascensionDay=Ascension Day"));
        return out;
    }
}

