/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.basics.IsNull;
import de.mhus.lib.core.IProperties;
import de.mhus.lib.core.IReadProperties;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.lang.MObject;
import de.mhus.lib.errors.MException;
import de.mhus.lib.errors.MRuntimeException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractProperties
extends MObject
implements IProperties {
    private static final long serialVersionUID = 1L;

    @Override
    public abstract Object getProperty(String var1);

    @Override
    public String getString(String name, String def) {
        Object out;
        try {
            out = this.getProperty(name);
        }
        catch (Throwable e) {
            return def;
        }
        if (out == null) {
            return def;
        }
        return String.valueOf(out);
    }

    @Override
    public String getString(String name) throws MException {
        Object out = this.getProperty(name);
        if (out == null) {
            return null;
        }
        return String.valueOf(out);
    }

    @Override
    public boolean getBoolean(String name, boolean def) {
        Object out;
        try {
            out = this.getProperty(name);
        }
        catch (Throwable e) {
            return def;
        }
        return MCast.toboolean(out, def);
    }

    @Override
    public boolean getBoolean(String name) throws MException {
        Object out = this.getProperty(name);
        if (out == null) {
            throw new MException(new Object[]{"value not found"});
        }
        return MCast.toboolean(out, false);
    }

    @Override
    public int getInt(String name, int def) {
        Object out;
        try {
            out = this.getProperty(name);
        }
        catch (Throwable e) {
            return def;
        }
        return MCast.toint(out, def);
    }

    @Override
    public long getLong(String name, long def) {
        Object out;
        try {
            out = this.getProperty(name);
        }
        catch (Throwable e) {
            return def;
        }
        return MCast.tolong(out, def);
    }

    @Override
    public float getFloat(String name, float def) {
        Object out;
        try {
            out = this.getProperty(name);
        }
        catch (Throwable e) {
            return def;
        }
        return MCast.tofloat(out, def);
    }

    @Override
    public double getDouble(String name, double def) {
        Object out;
        try {
            out = this.getProperty(name);
        }
        catch (Throwable e) {
            return def;
        }
        return MCast.todouble(out, def);
    }

    @Override
    public Calendar getCalendar(String name) throws MException {
        Object out = this.getProperty(name);
        return MCast.toCalendar(out);
    }

    @Override
    public Date getDate(String name) {
        try {
            Object out = this.getProperty(name);
            return MCast.toDate(out, null);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public void setString(String name, String value) {
        this.setProperty(name, value);
    }

    @Override
    public void setInt(String name, int value) {
        this.setProperty(name, value);
    }

    @Override
    public void setLong(String name, long value) {
        this.setProperty(name, value);
    }

    @Override
    public void setDouble(String name, double value) {
        this.setProperty(name, value);
    }

    @Override
    public void setFloat(String name, float value) {
        this.setProperty(name, Float.valueOf(value));
    }

    @Override
    public void setBoolean(String name, boolean value) {
        this.setProperty(name, value);
    }

    @Override
    public void setCalendar(String name, Calendar value) {
        this.setProperty(name, value);
    }

    @Override
    public void setDate(String name, Date value) {
        this.setProperty(name, value);
    }

    @Override
    public void setNumber(String name, Number value) {
        if (value == null) {
            this.removeProperty(name);
            return;
        }
        if (value instanceof Integer) {
            this.setInt(name, (Integer)value);
        } else if (value instanceof Long) {
            this.setLong(name, (Long)value);
        } else if (value instanceof Float) {
            this.setFloat(name, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.setDouble(name, (Double)value);
        } else {
            throw new MRuntimeException(new Object[]{"Unknown number class", name, value.getClass()});
        }
    }

    @Override
    public Number getNumber(String name, Number def) {
        Object out = this.getProperty(name);
        if (out == null) {
            return def;
        }
        if (out instanceof Number) {
            return (Number)out;
        }
        try {
            return MCast.todouble(out, 0.0);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    @Override
    public abstract boolean isProperty(String var1);

    @Override
    public abstract void removeProperty(String var1);

    public abstract void setProperty(String var1, Object var2);

    @Override
    public abstract boolean isEditable();

    @Override
    public abstract Set<String> keys();

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return new IPIterator();
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> out = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this) {
            out.put(entry.getKey(), entry.getValue());
        }
        return out;
    }

    @Override
    public abstract int size();

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        return this.isProperty(String.valueOf(key));
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        return this.getProperty(String.valueOf(key));
    }

    @Override
    public Object put(String key, Object value) {
        Object current = this.get(key);
        this.setProperty(key, value);
        return current;
    }

    @Override
    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        Object current = this.get(key);
        this.removeProperty(String.valueOf(key));
        return current;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> e : m.entrySet()) {
            if (e.getValue() instanceof IsNull) {
                this.remove(e.getKey());
                continue;
            }
            this.put(e.getKey(), e.getValue());
        }
    }

    public void putReadProperties(IReadProperties m) {
        for (Map.Entry<String, Object> e : m.entrySet()) {
            if (e.getValue() instanceof IsNull) {
                this.remove(e.getKey());
                continue;
            }
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Set<String> keySet() {
        return this.keys();
    }

    @Override
    public String getFormatted(String name, String def, Object ... values) {
        String format = this.getString(name, def);
        if (format == null) {
            return def;
        }
        return String.format(format, values);
    }

    private class IPEntry
    implements Map.Entry<String, Object> {
        private String key;

        public IPEntry(String next) {
            this.key = next;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            try {
                return AbstractProperties.this.getProperty(this.key);
            }
            catch (Throwable e) {
                throw new MRuntimeException(new Object[]{e});
            }
        }

        @Override
        public Object setValue(Object value) {
            Object old = null;
            try {
                old = AbstractProperties.this.getProperty(this.key);
            }
            catch (Throwable e1) {
                AbstractProperties.this.log().t(this.key, e1);
            }
            try {
                AbstractProperties.this.setProperty(this.key, value);
            }
            catch (Throwable e) {
                AbstractProperties.this.log().t(this.key, e);
            }
            return old;
        }
    }

    private class IPIterator
    implements Iterator<Map.Entry<String, Object>> {
        private Iterator<String> keys;
        private String currentkey;

        IPIterator() {
            this.keys = AbstractProperties.this.keys().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            this.currentkey = this.keys.next();
            return new IPEntry(this.currentkey);
        }

        @Override
        public void remove() {
            try {
                AbstractProperties.this.removeProperty(this.currentkey);
            }
            catch (Throwable e) {
                AbstractProperties.this.log().t(e);
            }
        }
    }
}

