/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.form;

import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.MString;
import de.mhus.lib.form.DataSource;
import de.mhus.lib.form.UiComponent;

public class PropertiesDataSource
implements DataSource {
    private MProperties properties;

    public MProperties getProperties() {
        return this.properties;
    }

    public void setProperties(MProperties properties) {
        this.properties = properties;
    }

    @Override
    public boolean getBoolean(UiComponent component, String name, boolean def) {
        return this.properties.getBoolean(this.toName(component.getName(), name), def);
    }

    @Override
    public int getInt(UiComponent component, String name, int def) {
        return this.properties.getInt(this.toName(component.getName(), name), def);
    }

    @Override
    public String getString(UiComponent component, String name, String def) {
        return this.properties.getString(this.toName(component.getName(), name), def);
    }

    @Override
    public Object getObject(UiComponent component, String name, Object def) {
        Object val = this.properties.getProperty(this.toName(component.getName(), name));
        if (val == null) {
            return def;
        }
        return val;
    }

    @Override
    public Object getObject(String name, Object def) {
        Object val = this.properties.getProperty(name);
        if (val == null) {
            return def;
        }
        return val;
    }

    @Override
    public void setObject(UiComponent component, String name, Object value) {
        this.properties.put(this.toName(component.getName(), name), value);
    }

    private String toName(String component, String name) {
        if (MString.isEmpty(name)) {
            return component;
        }
        return component + "." + name;
    }

    @Override
    public DataSource getNext() {
        return null;
    }
}

