/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.form;

import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.util.MNls;
import de.mhus.lib.core.util.MNlsProvider;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Item
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private String key;
    private String caption;
    private MNlsProvider provider;
    private String parent;

    public Item() {
    }

    public Item(String parent, String key, String caption) {
        this.key = key;
        this.caption = caption;
        this.parent = parent;
    }

    public Item(String key, String caption) {
        this.key = key;
        this.caption = caption;
    }

    public void setNlsProvider(MNlsProvider provider) {
        this.provider = provider;
    }

    public String toString() {
        return MNls.find(this.provider, this.caption);
    }

    public String getKey() {
        return this.key;
    }

    public String getParent() {
        return this.parent;
    }

    public String getCaption() {
        return this.caption;
    }

    public boolean equals(Object in) {
        if (in instanceof Item) {
            return MSystem.equals(((Item)in).getKey(), this.key);
        }
        return this.key.equals(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.key);
        out.writeObject(this.caption);
        out.writeObject(this.parent);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.key = (String)in.readObject();
        this.caption = (String)in.readObject();
        this.parent = (String)in.readObject();
    }
}

