/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.vault;

import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.vault.MutableVaultSource;
import de.mhus.lib.core.vault.VaultEntry;
import de.mhus.lib.errors.MException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;

public abstract class MapMutableVaultSource
extends MLog
implements MutableVaultSource {
    protected HashMap<UUID, VaultEntry> entries = new HashMap();
    protected String name = UUID.randomUUID().toString();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VaultEntry getEntry(UUID id) {
        HashMap<UUID, VaultEntry> hashMap = this.entries;
        synchronized (hashMap) {
            return this.entries.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<UUID> getEntryIds() {
        HashMap<UUID, VaultEntry> hashMap = this.entries;
        synchronized (hashMap) {
            return Collections.unmodifiableSet(this.entries.keySet());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntry(VaultEntry entry) throws MException {
        HashMap<UUID, VaultEntry> hashMap = this.entries;
        synchronized (hashMap) {
            this.entries.put(entry.getId(), entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntry(UUID id) throws MException {
        HashMap<UUID, VaultEntry> hashMap = this.entries;
        synchronized (hashMap) {
            this.entries.remove(id);
        }
    }

    public String toString() {
        return MSystem.toString(this, this.name, this.entries.size());
    }
}

