/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.vault;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.MValidator;
import de.mhus.lib.core.crypt.MCrypt;
import de.mhus.lib.core.util.SecureString;
import de.mhus.lib.core.vault.DefaultEntry;
import de.mhus.lib.core.vault.MapMutableVaultSource;
import de.mhus.lib.core.vault.MutableVaultSource;
import de.mhus.lib.core.vault.VaultEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.UUID;

public class FolderVaultSource
extends MapMutableVaultSource {
    private SecureString passphrase;
    private File folder;
    private int version;

    public FolderVaultSource(File folder, String passphrase, String name) throws IOException {
        this(folder, passphrase);
        this.name = name;
    }

    public FolderVaultSource(File folder, String passphrase) throws IOException {
        this.passphrase = new SecureString(passphrase);
        this.folder = folder;
        if (folder.exists()) {
            this.doLoad();
        } else {
            folder.mkdirs();
        }
    }

    @Override
    public void doLoad() throws IOException {
        this.version = 0;
        File file = new File(this.folder, "info.txt");
        if (file.exists()) {
            this.name = MFile.readFile(file).trim();
        }
        if ((file = new File(this.folder, "version.txt")).exists()) {
            this.version = MCast.toint(MFile.readFile(file).trim(), 0);
        }
        this.entries.clear();
        for (File file2 : this.folder.listFiles()) {
            if (file2.getName().startsWith(".") || !file2.isFile() || !MValidator.isUUID(file2.getName())) continue;
            this.loadEntry(file2);
        }
    }

    protected void loadEntry(File file) throws IOException {
        FileInputStream parent = new FileInputStream(file);
        InputStream is = MCrypt.createCipherInputStream(parent, this.passphrase.value());
        ObjectInputStream ois = new ObjectInputStream(is);
        try {
            FileEntry entry = new FileEntry(this.version, ois);
            this.addEntry(entry);
        }
        catch (Exception e) {
            this.log().w(file, e);
        }
        parent.close();
    }

    @Override
    public void doSave() throws IOException {
        this.version = 1;
        File file = new File(this.folder, "info.txt");
        MFile.writeFile(file, this.name);
        file = new File(this.folder, "version.txt");
        MFile.writeFile(file, "" + this.version);
        HashSet<String> ids = new HashSet<String>();
        for (VaultEntry entry : this.entries.values()) {
            ids.add(entry.getId().toString());
            this.saveEntry(entry);
        }
        for (File file2 : this.folder.listFiles()) {
            if (file2.getName().startsWith(".") || !file2.isFile() || !MValidator.isUUID(file2.getName()) || ids.contains(file2.getName())) continue;
            file2.delete();
        }
    }

    protected void saveEntry(VaultEntry entry) throws IOException {
        File file = new File(this.folder, entry.getId().toString());
        FileOutputStream parent = new FileOutputStream(file);
        OutputStream os = MCrypt.createCipherOutputStream(parent, this.passphrase.value());
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeInt(this.version);
        oos.writeUTF(entry.getId().toString());
        oos.writeUTF(entry.getType());
        oos.writeUTF(entry.getDescription());
        oos.writeObject(entry.getValue());
        oos.flush();
        parent.close();
    }

    @Override
    public String toString() {
        return MSystem.toString(this, this.name, this.entries.size(), this.folder);
    }

    @Override
    public boolean isMemoryBased() {
        return true;
    }

    @Override
    public MutableVaultSource getEditable() {
        return this;
    }

    private class FileEntry
    extends DefaultEntry {
        public FileEntry(int version, ObjectInputStream ois) throws IOException {
            int v;
            if (version == 0) {
                this.id = UUID.fromString(ois.readUTF());
                this.type = ois.readUTF();
                this.description = ois.readUTF();
                this.value = new SecureString(ois.readUTF());
            } else if (version > 0 && (v = ois.readInt()) == 1) {
                this.id = UUID.fromString(ois.readUTF());
                this.type = ois.readUTF();
                this.description = ois.readUTF();
                try {
                    this.value = (SecureString)ois.readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
            }
        }
    }
}

