/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.vault;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.cfg.CfgFile;
import de.mhus.lib.core.vault.FileVaultSource;
import de.mhus.lib.core.vault.FolderVaultSource;
import de.mhus.lib.core.vault.MVault;
import de.mhus.lib.core.vault.MapMutableVaultSource;
import de.mhus.lib.core.vault.VaultPassphrase;
import de.mhus.lib.core.vault.VaultSource;
import de.mhus.lib.core.vault.VaultSourceFactory;
import java.io.File;
import java.io.IOException;

public class DefaultVaultSourceFactory
extends MLog
implements VaultSourceFactory {
    private static CfgFile defaultFile = new CfgFile((Object)MVault.class, "file", MApi.getFile(MApi.SCOPE.ETC, "de.mhus.lib.core.vault.FileVaultSource.dat"));
    private static CfgFile defaultFolder = new CfgFile((Object)MVault.class, "file", MApi.getFile(MApi.SCOPE.DATA, "de.mhus.lib.core.vault.FolderVaultSource"));

    @Override
    public VaultSource create(String name, VaultPassphrase vaultPassphrase) {
        MapMutableVaultSource def = null;
        if ("default".equals(name)) {
            if (((File)defaultFile.value()).exists()) {
                try {
                    def = new FileVaultSource((File)defaultFile.value(), vaultPassphrase.getPassphrase(), name);
                }
                catch (IOException e) {
                    this.log().d(e);
                }
            } else {
                try {
                    def = new FolderVaultSource((File)defaultFolder.value(), vaultPassphrase.getPassphrase(), name);
                }
                catch (IOException e) {
                    this.log().w(e);
                }
            }
        } else {
            File file = new File(name);
            if (file.exists() && file.isFile()) {
                try {
                    def = new FileVaultSource(file, vaultPassphrase.getPassphrase(), file.getName());
                }
                catch (IOException e) {
                    this.log().d(e);
                }
            } else {
                try {
                    def = new FolderVaultSource(file, vaultPassphrase.getPassphrase(), file.getName());
                }
                catch (IOException e) {
                    this.log().w(e);
                }
            }
        }
        return def;
    }
}

