/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.vault;

import de.mhus.lib.core.crypt.AsyncKey;
import de.mhus.lib.core.crypt.MCrypt;
import de.mhus.lib.core.crypt.pem.PemPriv;
import de.mhus.lib.core.crypt.pem.PemPub;
import de.mhus.lib.core.crypt.pem.PemUtil;
import de.mhus.lib.core.parser.ParseException;
import de.mhus.lib.core.vault.VaultEntry;
import de.mhus.lib.core.vault.VaultMutator;
import de.mhus.lib.errors.NotSupportedException;

public class DefaultVaultMutator
implements VaultMutator {
    @Override
    public <T> T adaptTo(VaultEntry entry, Class<? extends T> ifc) throws ParseException, NotSupportedException {
        if (entry.getType() != null) {
            try {
                if (ifc == AsyncKey.class && "rsa.cipher.private.key".equals(entry.getType())) {
                    return (T)MCrypt.loadPrivateRsaKey(entry.getValue().value());
                }
                if (ifc == AsyncKey.class && "rsa.cipher.public.key".equals(entry.getType())) {
                    return (T)MCrypt.loadPrivateRsaKey(entry.getValue().value());
                }
                if (ifc == PemPriv.class && entry.getType().endsWith(".cipher.private.key")) {
                    return (T)PemUtil.cipherPrivFromString(entry.getValue().value());
                }
                if (ifc == PemPub.class && entry.getType().endsWith(".cipher.public.key")) {
                    return (T)PemUtil.cipherPubFromString(entry.getValue().value());
                }
                if (ifc == PemPriv.class && entry.getType().endsWith(".sign.private.key")) {
                    return (T)PemUtil.signPrivFromString(entry.getValue().value());
                }
                if (ifc == PemPub.class && entry.getType().endsWith(".sign.public.key")) {
                    return (T)PemUtil.signPubFromString(entry.getValue().value());
                }
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
        throw new NotSupportedException(new Object[]{entry, ifc});
    }
}

