/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.vault;

import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.util.SecureString;
import de.mhus.lib.core.vault.VaultEntry;
import java.util.UUID;

public class DefaultEntry
implements VaultEntry {
    protected UUID id = UUID.randomUUID();
    protected String type;
    protected String description;
    protected SecureString value;

    public DefaultEntry() {
    }

    public DefaultEntry(UUID id, String type, String description, String value) {
        this(type, description, value);
        this.id = id;
    }

    public DefaultEntry(UUID id, String type, String description, SecureString value) {
        this(type, description, value);
        this.id = id;
    }

    public DefaultEntry(String type, String description, String value) {
        this.type = type;
        this.description = description;
        this.value = new SecureString(value);
    }

    public DefaultEntry(String type, String description, SecureString value) {
        this.type = type;
        this.description = description;
        this.value = value;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public SecureString getValue() {
        return this.value;
    }

    public String toString() {
        return MSystem.toString(this, this.id, this.type);
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

