/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.annotations.activator.DefaultImplementation;
import de.mhus.lib.core.M;
import de.mhus.lib.core.lang.MObject;
import de.mhus.lib.core.util.MNls;
import de.mhus.lib.core.util.MNlsBundleFactory;
import de.mhus.lib.core.util.MNlsFactory;
import java.util.HashMap;
import java.util.Locale;

@DefaultImplementation(value=MNlsFactory.class)
public abstract class MNlsBundle
extends MObject {
    private String path;
    private MNls defaultNls;
    private HashMap<String, Object> cache = new HashMap();

    public MNlsBundle() {
    }

    public MNlsBundle(String path) {
        this.setPath(path);
    }

    public MNlsBundle(Object owner) {
        this.setPath(MNlsFactory.toResourceName(owner));
    }

    public MNls getNls(Locale locale) {
        if (locale == null) {
            return this.getDefaultNls();
        }
        String tag = locale.toLanguageTag();
        MNls out = this.getNls(tag);
        if (out != null) {
            return out;
        }
        tag = locale.getLanguage();
        out = this.getNls(tag);
        if (out != null) {
            return out;
        }
        return this.getDefaultNls();
    }

    public synchronized MNls getDefaultNls() {
        if (this.defaultNls != null) {
            return this.defaultNls;
        }
        this.defaultNls = this.getNls("");
        if (this.defaultNls == null) {
            this.defaultNls = new MNls();
        }
        return this.defaultNls;
    }

    public synchronized MNls getNls(String locale) {
        Object out = this.cache.get(locale);
        if (out != null) {
            if (out instanceof MNls) {
                return (MNls)out;
            }
            return null;
        }
        out = this.createNls(locale);
        if (out == null || !(out instanceof MNls) || ((MNls)out).size() == 0) {
            out = new Object();
        }
        this.cache.put(locale, out);
        if (out instanceof MNls) {
            return (MNls)out;
        }
        return null;
    }

    public abstract MNls createNls(String var1);

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public MNlsBundle setOwner(Object owner) {
        this.setPath(MNlsFactory.toResourceName(owner));
        return this;
    }

    public static MNlsBundle lookup(Object owner) {
        MNlsBundleFactory factory = M.l(MNlsBundleFactory.class);
        MNlsBundle nlsBundle = factory.create(owner);
        return nlsBundle;
    }
}

