/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import java.awt.Color;
import java.awt.Container;
import java.awt.TextArea;

public class JreVersionCheck {
    static final boolean DEBUGGING = false;

    public static boolean isJavaVersionOK(int wantedMajor, int wantedMinor, int wantedBugFix) {
        try {
            try {
                int gotMinor;
                char ch;
                int gotMajor;
                Object ver = System.getProperty("java.version");
                if (ver == null) {
                    return false;
                }
                if (((String)(ver = ((String)ver).trim())).length() < 2) {
                    return false;
                }
                int dex = ((String)ver).indexOf(46);
                if (dex < 0) {
                    ver = ((String)ver).charAt(0) + 46 + ((String)ver).substring(1);
                    dex = 1;
                }
                if ((gotMajor = Integer.parseInt(((String)ver).substring(0, dex))) < wantedMajor) {
                    return false;
                }
                if (gotMajor > wantedMajor) {
                    return true;
                }
                if (((String)(ver = ((String)ver).substring(dex + 1))).endsWith("beta")) {
                    ver = ((String)ver).substring(0, ((String)ver).length() - "beta".length());
                }
                if (((String)ver).endsWith("-rc")) {
                    ver = ((String)ver).substring(0, ((String)ver).length() - "-rc".length());
                }
                if ((dex = ((String)ver).lastIndexOf(95)) >= 0) {
                    ver = ((String)ver).substring(0, dex);
                }
                if (!Character.isDigit(ch = ((String)ver).charAt(((String)ver).length() - 1))) {
                    ver = ((String)ver).substring(0, ((String)ver).length() - 1);
                    if (ch == 'x' || ch == 'X') {
                        ver = (String)ver + "9";
                    }
                }
                if ((dex = ((String)ver).indexOf(46)) < 0) {
                    ver = (String)ver + ".0";
                    dex = ((String)ver).indexOf(46);
                }
                if ((gotMinor = Integer.parseInt(((String)ver).substring(0, dex))) < wantedMinor) {
                    return false;
                }
                if (gotMinor > wantedMinor) {
                    return true;
                }
                int gotBugFix = Integer.parseInt((String)(ver = ((String)ver).substring(dex + 1)));
                return gotBugFix >= wantedBugFix;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            return false;
        }
    }

    public static boolean isJavaVersionOK(int wantedMajor, int wantedMinor, int wantedBugFix, Container container) {
        if (JreVersionCheck.isJavaVersionOK(wantedMajor, wantedMinor, wantedBugFix)) {
            return true;
        }
        String error = "Error: You need Java " + wantedMajor + "." + wantedMinor + "." + wantedBugFix + " or later to run this Applet.\nYou are currently running under Java " + System.getProperty("java.version") + ".\nGet the latest Java from http://java.com/en/index.jsp";
        TextArea complain = new TextArea(error, 3, 42, 3);
        complain.setEditable(false);
        complain.setBackground(Color.white);
        complain.setForeground(Color.red);
        complain.setSize(300, 50);
        container.setLayout(null);
        container.add(complain);
        System.err.println(error);
        return false;
    }

    private JreVersionCheck() {
    }
}

