/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.strategy;

import de.mhus.lib.core.MLog;
import de.mhus.lib.core.logging.LogProperties;
import de.mhus.lib.core.strategy.NotSuccessful;
import de.mhus.lib.core.strategy.Operation;
import de.mhus.lib.core.strategy.OperationDescription;
import de.mhus.lib.core.strategy.OperationResult;
import de.mhus.lib.core.strategy.TaskContext;
import de.mhus.lib.core.util.MNls;
import de.mhus.lib.core.util.ParameterDefinition;
import de.mhus.lib.core.util.ParameterDefinitions;
import java.util.Map;
import java.util.UUID;

public abstract class AbstractOperation
extends MLog
implements Operation {
    private Object owner;
    private OperationDescription description;
    private MNls nls;
    private UUID uuid = UUID.randomUUID();

    @Override
    public boolean hasAccess() {
        return true;
    }

    @Override
    public final OperationResult doExecute(TaskContext context) throws Exception {
        this.log().d("execute", new LogProperties((Map<String, Object>)context.getParameters()));
        if (!this.hasAccess()) {
            this.log().d("access denied", context, context.getErrorMessage());
            return new NotSuccessful(this, "access denied", -401L);
        }
        if (!this.canExecute(context)) {
            this.log().d("execution denied", context.getErrorMessage());
            return new NotSuccessful(this, context.getErrorMessage() != null ? context.getErrorMessage() : "can't execute", -12L);
        }
        OperationResult ret = this.doExecute2(context);
        this.log().d("result", ret);
        return ret;
    }

    protected abstract OperationResult doExecute2(TaskContext var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBusy() {
        AbstractOperation abstractOperation = this;
        synchronized (abstractOperation) {
            return this.owner != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setBusy(Object owner) {
        AbstractOperation abstractOperation = this;
        synchronized (abstractOperation) {
            if (this.owner != null) {
                return false;
            }
            this.owner = owner;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean releaseBusy(Object owner) {
        AbstractOperation abstractOperation = this;
        synchronized (abstractOperation) {
            if (this.owner == null) {
                return true;
            }
            if (this.owner != owner) {
                return false;
            }
            this.owner = null;
        }
        return true;
    }

    @Override
    public boolean canExecute(TaskContext context) {
        if (this.getDescription() == null) {
            return true;
        }
        return AbstractOperation.validateParameters(this.getDescription().getParameterDefinitions(), context);
    }

    @Override
    public OperationDescription getDescription() {
        if (this.description == null) {
            this.description = this.createDescription();
        }
        return this.description;
    }

    protected abstract OperationDescription createDescription();

    public static boolean validateParameters(ParameterDefinitions definitions, TaskContext context) {
        if (definitions == null) {
            return true;
        }
        for (ParameterDefinition def : definitions.values()) {
            Object v = context.getParameters().get(def.getName());
            if (!def.isMandatory() || v != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public MNls getNls() {
        if (this.nls == null) {
            this.nls = MNls.lookup(this);
        }
        return this.nls;
    }

    @Override
    public String nls(String text) {
        return MNls.find(this, text);
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }
}

