/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.io.http;

import de.mhus.lib.core.lang.MObject;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class MHttpClientBuilder
extends MObject {
    private CloseableHttpClient hc;
    private String proxyHost;
    private int proxyPort = 3128;
    private BasicCookieStore cookieStore;
    private boolean useSystemProperties;
    protected HttpClientConnectionManager connManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient getHttpClient() {
        MHttpClientBuilder mHttpClientBuilder = this;
        synchronized (mHttpClientBuilder) {
            if (this.hc == null) {
                HttpClientBuilder build = HttpClients.custom();
                this.configureConnectionManager(build);
                this.configureProxy(build);
                this.configureCookieStore(build);
                this.configureProtocolHandling(build);
                this.configureBuilder(build);
                this.hc = build.build();
            }
        }
        return this.hc;
    }

    protected void configureConnectionManager(HttpClientBuilder build) {
        build.setConnectionManagerShared(false);
        this.connManager = new PoolingHttpClientConnectionManager();
        ((PoolingHttpClientConnectionManager)this.connManager).setMaxTotal(100);
        ((PoolingHttpClientConnectionManager)this.connManager).setDefaultMaxPerRoute(100);
        build.setConnectionManager(this.connManager);
    }

    protected void configureBuilder(HttpClientBuilder build) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MHttpClientBuilder mHttpClientBuilder = this;
        synchronized (mHttpClientBuilder) {
            if (this.hc != null) {
                try {
                    this.hc.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.hc = null;
            if (this.connManager != null) {
                this.connManager.closeIdleConnections(0L, TimeUnit.NANOSECONDS);
            }
            this.connManager = null;
        }
    }

    public boolean exists() {
        return this.hc != null;
    }

    protected void configureProtocolHandling(HttpClientBuilder build) {
        if (this.useSystemProperties) {
            build.useSystemProperties();
        }
    }

    protected void configureCookieStore(HttpClientBuilder build) {
        if (this.cookieStore == null) {
            this.cookieStore = new BasicCookieStore();
        }
        build.setDefaultCookieStore((CookieStore)this.cookieStore);
    }

    protected void configureProxy(HttpClientBuilder build) {
        if (this.proxyHost != null) {
            HttpHost proxy = new HttpHost(this.proxyHost, this.proxyPort);
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            build.setRoutePlanner((HttpRoutePlanner)routePlanner);
        }
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public MHttpClientBuilder setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public MHttpClientBuilder setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public BasicCookieStore getCookieStore() {
        return this.cookieStore;
    }

    public MHttpClientBuilder setCookieStore(BasicCookieStore cookieStore) {
        this.cookieStore = cookieStore;
        return this;
    }

    public boolean isUseSystemProperties() {
        return this.useSystemProperties;
    }

    public MHttpClientBuilder setUseSystemProperties(boolean useSystemProperties) {
        this.useSystemProperties = useSystemProperties;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        MHttpClientBuilder mHttpClientBuilder = this;
        synchronized (mHttpClientBuilder) {
            if (this.connManager != null) {
                this.connManager.closeIdleConnections(1L, TimeUnit.SECONDS);
            }
        }
    }

    public static void close(HttpResponse response) {
        if (response == null || !(response instanceof CloseableHttpResponse)) {
            return;
        }
        try {
            ((CloseableHttpResponse)response).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void consume(HttpEntity entity) {
        if (entity == null) {
            return;
        }
        try {
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

