/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.io.http;

import de.mhus.lib.core.IProperties;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MFile;
import de.mhus.lib.core.io.http.MHttpClientBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;

public class MHttp {
    public static final Map<Integer, String> HTTP_STATUS_CODES = Collections.unmodifiableMap(new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(100, "Continue");
            this.put(101, "Switching Protocols");
            this.put(200, "OK");
            this.put(201, "Created");
            this.put(202, "Accepted");
            this.put(203, "Non-Authoritative Information");
            this.put(204, "No Content");
            this.put(205, "Reset Content");
            this.put(300, "Multiple Choices");
            this.put(301, "Moved Permanently");
            this.put(302, "Found");
            this.put(303, "See Other");
            this.put(304, "Not Modified");
            this.put(305, "Use Proxy");
            this.put(307, "Temporary Redirect");
            this.put(400, "Bad Request");
            this.put(401, "Unauthorized");
            this.put(402, "Payment Required");
            this.put(403, "Forbidden");
            this.put(404, "Not Found");
            this.put(405, "Method Not Allowed");
            this.put(406, "Not Acceptable");
            this.put(407, "Proxy Authentication Required");
            this.put(408, "Request Time-out");
            this.put(409, "Conflict");
            this.put(410, "Gone");
            this.put(411, "Length Required");
            this.put(412, "Precondition Failed");
            this.put(413, "Request Entity Too Large");
            this.put(414, "Request-URI Too Large");
            this.put(415, "Unsupported Media Type");
            this.put(416, "Requested range not satisfiable");
            this.put(417, "SlimExpectation Failed");
            this.put(500, "Internal Server Error");
            this.put(501, "Not Implemented");
            this.put(502, "Bad Gateway");
            this.put(503, "Service Unavailable");
            this.put(504, "Gateway Time-out");
            this.put(505, "HTTP Version not supported");
        }
    });
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String CONTENT_TYPE_HTML = "text/html";
    public static final String CONTENT_TYPE_TEXT = "text/plain";
    public static final String CONTENT_TYPE_PDF = "application/pdf";
    private static MHttpClientBuilder client;

    public static METHOD toMethod(String in) {
        return METHOD.valueOf(in.trim().toUpperCase());
    }

    public static String getContentType(String extension) {
        return MFile.getMimeType(extension);
    }

    public static synchronized HttpClient getSharedClient() {
        if (client == null) {
            client = new MHttpClientBuilder(){

                @Override
                protected void configureConnectionManager(HttpClientBuilder build) {
                    super.configureConnectionManager(build);
                    ((PoolingHttpClientConnectionManager)this.connManager).setMaxTotal(10000);
                    ((PoolingHttpClientConnectionManager)this.connManager).setDefaultMaxPerRoute(10000);
                }
            };
            client.setUseSystemProperties(true);
        }
        client.cleanup();
        return client.getHttpClient();
    }

    public static void setFormParameters(HttpPost action, String ... values) {
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        for (int i = 0; i < values.length; i += 2) {
            formparams.add(new BasicNameValuePair(values[i], values[i + 1]));
        }
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formparams, Consts.UTF_8);
        action.setEntity((HttpEntity)entity);
    }

    public static void setFormParameters(HttpPost action, IProperties params) {
        ArrayList formparams = new ArrayList();
        params.forEach(e -> formparams.add(new BasicNameValuePair((String)e.getKey(), MCast.toString(e.getValue()))));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formparams, Consts.UTF_8);
        action.setEntity((HttpEntity)entity);
    }

    public static enum METHOD {
        GET,
        HEAD,
        POST,
        PUT,
        DELETE,
        CONNECT,
        OPTIONS,
        TRACE,
        PATCH;

    }
}

