/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.io;

import de.mhus.lib.core.IReadProperties;
import de.mhus.lib.core.MXml;
import de.mhus.lib.core.io.StreamBuffer;
import de.mhus.lib.core.io.StreamRewriter;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UserFieldValuesRewriter
implements StreamRewriter {
    private IReadProperties values;

    public UserFieldValuesRewriter(IReadProperties values) {
        this.values = values;
    }

    @Override
    public InputStream rewriteContent(String file, InputStream in) throws Exception {
        if (!file.equals("content.xml")) {
            return in;
        }
        Document content = MXml.loadXml(in);
        NodeList list = content.getDocumentElement().getElementsByTagName("text:user-field-decl");
        for (int i = 0; i < list.getLength(); ++i) {
            Element node = (Element)list.item(i);
            String name = node.getAttribute("text:name");
            String value = this.values.getString(name, null);
            if (value == null) continue;
            node.setAttribute("office:string-value", value);
        }
        StreamBuffer buffer = new StreamBuffer();
        MXml.saveXml((Node)content, buffer.getOutputStream());
        return buffer.getInputStream();
    }
}

