/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.io;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TailInputStream
extends InputStream {
    private File file;
    private long pos;
    private FileInputStream is;
    private boolean closed = false;

    public TailInputStream(File file) throws IOException {
        this.file = file;
        this.clean();
    }

    @Override
    public int read() throws IOException {
        int ret;
        if (this.closed) {
            throw new EOFException();
        }
        long size = this.file.length();
        while (size == this.pos) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                throw new EOFException();
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new EOFException();
            }
            if (this.closed) {
                throw new EOFException();
            }
            size = this.file.length();
        }
        if (size < this.pos) {
            this.pos = 0L;
            try {
                this.is.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.is = new FileInputStream(this.file);
        }
        if ((ret = this.is.read()) >= 0) {
            ++this.pos;
        }
        return ret;
    }

    public long delta() {
        long size = this.file.length();
        if (size > this.pos) {
            return size - this.pos;
        }
        return size;
    }

    @Override
    public int available() {
        long size = this.delta();
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.is != null) {
            this.is.close();
        }
        super.close();
    }

    public void clean() throws IOException {
        this.pos = this.file.length();
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.is = new FileInputStream(this.file);
        this.is.skip(this.pos);
    }
}

