/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.io;

import de.mhus.lib.core.MThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;

public class PipedStream {
    private Out out = new Out();
    private In in = new In();
    private LinkedList<Byte> buffer = new LinkedList();
    private int maxBufferSize = 3000;
    private long writeTimeout = -1L;
    private long readTimeout = -1L;

    public OutputStream getOut() {
        return this.out;
    }

    public InputStream getIn() {
        return this.in;
    }

    public int getBufferSize() {
        return this.buffer.size();
    }

    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public void setWriteTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    private class In
    extends InputStream {
        private In() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            In in = this;
            synchronized (in) {
                long time = 0L;
                while (PipedStream.this.buffer.size() == 0) {
                    if (PipedStream.this.getReadTimeout() >= 0L && time >= PipedStream.this.getReadTimeout()) {
                        throw new IOException("timeout", null);
                    }
                    MThread.sleep(100L);
                    if (PipedStream.this.getReadTimeout() < 0L) continue;
                    time += 100L;
                }
                LinkedList<Byte> linkedList = PipedStream.this.buffer;
                synchronized (linkedList) {
                    Byte first = PipedStream.this.buffer.removeFirst();
                    return first.byteValue();
                }
            }
        }
    }

    private class Out
    extends OutputStream {
        private Out() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            Out out = this;
            synchronized (out) {
                long time = 0L;
                while (PipedStream.this.buffer.size() >= PipedStream.this.maxBufferSize) {
                    if (PipedStream.this.getWriteTimeout() >= 0L && time >= PipedStream.this.getWriteTimeout()) {
                        throw new IOException("timeout", null);
                    }
                    MThread.sleep(100L);
                    if (PipedStream.this.getWriteTimeout() < 0L) continue;
                    time += 100L;
                }
                LinkedList<Byte> linkedList = PipedStream.this.buffer;
                synchronized (linkedList) {
                    PipedStream.this.buffer.addLast((byte)b);
                }
            }
        }
    }
}

