/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.io;

import de.mhus.lib.core.M;
import de.mhus.lib.core.MHousekeeper;
import de.mhus.lib.core.MHousekeeperTask;
import java.io.File;

public class FileWatch
extends MHousekeeperTask {
    private File file;
    private long period = 30000L;
    private long modified = -2L;
    private Listener listener;
    private boolean started = false;
    private long lastRun;
    private boolean startHook;
    private boolean registered = false;

    public FileWatch(File fileToWatch, Listener listener) {
        this(fileToWatch, 30000L, true, listener);
    }

    public FileWatch(File fileToWatch, long period, boolean startHook, Listener listener) {
        this.file = fileToWatch;
        this.period = period;
        this.startHook = startHook;
        this.listener = listener;
        this.setName(this.file.getName());
    }

    public FileWatch doStart() {
        if (this.started) {
            return this;
        }
        this.started = true;
        if (!this.file.exists()) {
            this.log().w("file not found", this.file);
        }
        if (this.startHook) {
            this.checkFile();
        }
        if (!this.registered) {
            MHousekeeper housekeeper = M.l(MHousekeeper.class);
            housekeeper.register(this, this.period);
            this.registered = true;
        }
        return this;
    }

    public FileWatch doStop() {
        if (!this.started) {
            return this;
        }
        return this;
    }

    public void checkFile() {
        block10: {
            if (System.currentTimeMillis() - this.lastRun < this.period) {
                return;
            }
            this.lastRun = System.currentTimeMillis();
            try {
                long modSum = 0L;
                if (this.file.exists()) {
                    if (this.file.isFile()) {
                        modSum = this.file.lastModified();
                    } else if (this.file.isDirectory()) {
                        for (File f : this.file.listFiles()) {
                            if (!f.isFile() || f.isHidden()) continue;
                            modSum += f.lastModified();
                        }
                    }
                } else {
                    modSum = -1L;
                }
                if (this.modified != -2L && this.listener != null && this.modified != modSum) {
                    this.listener.onFileChanged(this);
                }
                this.modified = modSum;
            }
            catch (Throwable t) {
                if (this.listener == null) break block10;
                this.listener.onFileWatchError(this, t);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file != null ? this.file.getAbsolutePath() : "?";
    }

    @Override
    protected void doit() throws Exception {
        this.checkFile();
    }

    public static interface Listener {
        public void onFileChanged(FileWatch var1);

        public void onFileWatchError(FileWatch var1, Throwable var2);
    }
}

