/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.directory;

import de.mhus.lib.core.AbstractProperties;
import de.mhus.lib.core.IProperties;
import de.mhus.lib.core.MCollection;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.parser.CompiledString;
import de.mhus.lib.core.parser.DefaultScriptPart;
import de.mhus.lib.core.parser.StringCompiler;
import de.mhus.lib.core.parser.StringPart;
import de.mhus.lib.errors.MException;
import de.mhus.lib.errors.MRuntimeException;
import de.mhus.lib.errors.NotSupportedException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class ResourceNode<T extends ResourceNode<?>>
extends AbstractProperties {
    private static final long serialVersionUID = 1L;
    protected ConfigStringCompiler compiler;
    protected HashMap<String, CompiledString> compiledCache;

    public abstract Collection<String> getPropertyKeys();

    public abstract T getNode(String var1);

    public abstract Collection<T> getNodes();

    public abstract Collection<T> getNodes(String var1);

    public abstract Collection<String> getNodeKeys();

    public abstract String getName() throws MException;

    public InputStream getInputStream() {
        return this.getInputStream(null);
    }

    public abstract InputStream getInputStream(String var1);

    public abstract Collection<String> getRenditions();

    public IProperties getRenditionProperties() {
        return this.getRenditionProperties(null);
    }

    public abstract IProperties getRenditionProperties(String var1);

    public String getExtracted(String key) {
        return this.getExtracted(key, null);
    }

    public String getExtracted(String key, String def) {
        return this.getExtracted(key, def, 0);
    }

    public abstract ResourceNode<?> getParent();

    @Override
    public Set<String> keys() {
        return MCollection.toSet(this.getPropertyKeys());
    }

    protected String getExtracted(String key, String def, int level) {
        if (level > 10) {
            return def;
        }
        String value = this.getString(key, null);
        if (value == null) {
            return def;
        }
        if (value.indexOf(36) < 0) {
            return value;
        }
        ResourceNode resourceNode = this;
        synchronized (resourceNode) {
            CompiledString cached;
            if (this.compiler == null) {
                this.compiler = new ConfigStringCompiler();
                this.compiledCache = new HashMap();
            }
            if ((cached = this.compiledCache.get(key)) == null) {
                cached = this.compiler.compileString(value);
                this.compiledCache.put(key, cached);
            }
            try {
                return cached.execute(new ConfigMap(level, this));
            }
            catch (MException e) {
                throw new MRuntimeException(new Object[]{key, e});
            }
        }
    }

    public abstract URL getUrl();

    public abstract boolean isValid();

    public abstract boolean hasContent();

    public T getNodeByPath(String path) {
        if (path == null) {
            return null;
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.length() == 0) {
            return (T)this;
        }
        int p = path.indexOf(47);
        if (p < 0) {
            return this.getNode(path);
        }
        T next = this.getNode(path.substring(0, p));
        if (next == null) {
            return null;
        }
        return ((ResourceNode)next).getNodeByPath(path.substring(p + 1));
    }

    public String dump() throws MException {
        StringBuilder sb = new StringBuilder();
        this.dump(sb, 0);
        return sb.toString();
    }

    void dump(StringBuilder sb, int level) throws MException {
        sb.append(MString.getRepeating(level, ' '));
        sb.append('<').append(this.getName());
        for (String key : this.keys()) {
            sb.append('\n').append(MString.getRepeating(level + 2, ' ')).append(key).append("='").append(this.getString(key)).append("'");
        }
        sb.append(">\n");
        for (ResourceNode node : this.getNodes()) {
            node.dump(sb, level + 2);
        }
        sb.append(MString.getRepeating(level, ' '));
        sb.append("</").append(this.getName()).append(">\n");
    }

    @Override
    public int size() {
        Collection<String> keys = this.getPropertyKeys();
        if (keys == null) {
            return 0;
        }
        return keys.size();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public Collection<Object> values() {
        HashMap<String, Object> out = new HashMap<String, Object>();
        for (String key : this.getPropertyKeys()) {
            out.put(key, this.getProperty(key));
        }
        return out.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashMap<String, Object> out = new HashMap<String, Object>();
        for (String key : this.getPropertyKeys()) {
            out.put(key, this.getProperty(key));
        }
        return out.entrySet();
    }

    private static class ConfigMap
    implements Map<String, Object> {
        private int level;
        private ResourceNode<?> config;

        private ConfigMap(int level) {
            this.level = level;
        }

        private ConfigMap(int level, ResourceNode<?> config) {
            this.level = level;
            this.config = config;
        }

        @Override
        public int size() {
            return this.config == null ? 0 : this.config.size();
        }

        public int getLevel() {
            return this.level;
        }

        @Override
        public boolean isEmpty() {
            return this.config == null ? true : this.config.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.config == null ? false : this.config.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.config == null ? false : this.config.containsValue(value);
        }

        @Override
        public Object get(Object key) {
            return this.config == null ? null : this.config.get(key);
        }

        @Override
        public Object put(String key, Object value) {
            return null;
        }

        @Override
        public Object remove(Object key) {
            return null;
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
        }

        @Override
        public void clear() {
        }

        @Override
        public Set<String> keySet() {
            return this.config == null ? null : this.config.keySet();
        }

        @Override
        public Collection<Object> values() {
            return null;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return null;
        }
    }

    private class ConfigAttributePart
    implements StringPart {
        private String name;
        private String def;
        private ResourceNode<?> config;

        public ConfigAttributePart(String part) {
            this.name = part;
            int pos = this.name.indexOf(44);
            if (pos > 0) {
                this.def = this.name.substring(pos + 1);
                this.name = this.name.substring(0, pos);
            }
            this.config = ResourceNode.this;
            if (this.name.startsWith("/")) {
                while (this.config.getParent() != null) {
                    this.config = this.config.getParent();
                }
                this.name = this.name.substring(1);
            } else {
                while (this.name.startsWith("../")) {
                    this.config = this.config.getParent();
                    this.name = this.name.substring(3);
                    if (this.config != null) continue;
                    break;
                }
            }
        }

        @Override
        public void execute(StringBuilder out, Map<String, Object> attributes) throws MException {
            int level = 0;
            if (attributes != null && attributes instanceof ConfigMap) {
                level = ((ConfigMap)attributes).getLevel();
            }
            if (this.config == null) {
                out.append(this.def);
            } else {
                out.append(this.config.getExtracted(this.name, this.def, level));
            }
        }

        @Override
        public void dump(int level, StringBuilder out) {
            MString.appendRepeating(level, ' ', out);
            out.append(this.getClass().getCanonicalName()).append(this.name).append("(").append(this.def).append(")");
        }
    }

    private class RootAttributePart
    implements StringPart {
        private String name;
        private String def;
        private ResourceNode<?> root;

        public RootAttributePart(String part) {
            this.name = MString.afterIndex(part, ':');
            this.root = ResourceNode.this;
            while (this.root.getParent() != null && this.root.getParent() != this.root) {
                this.root = this.root.getParent();
            }
            int pos = this.name.indexOf(44);
            if (pos > 0) {
                this.def = this.name.substring(pos + 1);
                this.name = this.name.substring(0, pos);
            }
        }

        @Override
        public void execute(StringBuilder out, Map<String, Object> attributes) throws MException {
            out.append(this.root.getString(this.name, this.def));
        }

        @Override
        public void dump(int level, StringBuilder out) {
            MString.appendRepeating(level, ' ', out);
            out.append(this.getClass().getCanonicalName()).append(this.name).append("(").append(this.def).append(")");
        }
    }

    private class ConfigStringCompiler
    extends StringCompiler {
        private ConfigStringCompiler() {
        }

        @Override
        protected StringPart createDefaultAttributePart(String part) {
            if (part.startsWith(">root:")) {
                return new RootAttributePart(part);
            }
            if (part.startsWith(">js:")) {
                return new DefaultScriptPart(part);
            }
            return new ConfigAttributePart(part);
        }
    }
}

