/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.currency;

import de.mhus.lib.core.MString;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;

public class CCurrency
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final CCurrency UNKNOWN = new CCurrency("?", "");
    public static final String SCHEME_FIAT_PREFIX = "fiat-";
    private static HashMap<String, CCurrency> schemeMapping = new HashMap();
    private String name;
    private String scheme;

    public CCurrency(String in) {
        if (in == null) {
            throw new NullPointerException("Currency name can't be null");
        }
        this.name = in.trim().toUpperCase();
        if (this.scheme == null) {
            this.scheme = "";
        }
        this.scheme = CCurrency.getSchemeForCurrency(in);
    }

    public CCurrency(String in, String scheme) {
        if (in == null) {
            throw new NullPointerException("Currency name can't be null");
        }
        this.name = in.trim().toUpperCase();
        if (scheme == null) {
            scheme = "";
        }
        this.scheme = scheme.trim().toLowerCase();
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object in) {
        if (in == null) {
            return false;
        }
        return this.name.equals(in.toString());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.scheme);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.scheme = in.readUTF();
    }

    public CRYPTO_CURRENCY toCryptoCurrency() {
        try {
            return CRYPTO_CURRENCY.valueOf(this.name);
        }
        catch (IllegalArgumentException e) {
            return CRYPTO_CURRENCY.UNKNOWN;
        }
    }

    public FIAT_CURRENCY toFiatCurrency() {
        try {
            return FIAT_CURRENCY.valueOf(this.name);
        }
        catch (IllegalArgumentException e) {
            return FIAT_CURRENCY.UNKNOWN;
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public static String getSchemeForCurrency(String currency) {
        try {
            currency = currency.trim().toUpperCase();
            return CRYPTO_CURRENCY.valueOf(currency).getScheme();
        }
        catch (Throwable e) {
            return "";
        }
    }

    public String getName() {
        return this.name;
    }

    public static CCurrency getCurrenctyForName(String name) {
        if (name == null) {
            return UNKNOWN;
        }
        CCurrency s = schemeMapping.get((name = name.trim()).toLowerCase());
        if (s != null) {
            return s;
        }
        String currency = name.toUpperCase();
        try {
            return CRYPTO_CURRENCY.valueOf(currency).toCurrency();
        }
        catch (Throwable throwable) {
            try {
                return FIAT_CURRENCY.valueOf(currency).toCurrency();
            }
            catch (Throwable throwable2) {
                return UNKNOWN;
            }
        }
    }

    public boolean isUnknown() {
        return "?".equals(this.name) || "fiat-?".equals(this.name) || MString.isEmpty(this.name);
    }

    public boolean isFiat() {
        return this.scheme.startsWith(SCHEME_FIAT_PREFIX);
    }

    static {
        for (CRYPTO_CURRENCY cRYPTO_CURRENCY : CRYPTO_CURRENCY.values()) {
            if (cRYPTO_CURRENCY == CRYPTO_CURRENCY.UNKNOWN) continue;
            schemeMapping.put(cRYPTO_CURRENCY.getScheme(), cRYPTO_CURRENCY.toCurrency());
        }
        for (Enum enum_ : FIAT_CURRENCY.values()) {
            if (enum_ == FIAT_CURRENCY.UNKNOWN) continue;
            schemeMapping.put(((FIAT_CURRENCY)enum_).getScheme(), ((FIAT_CURRENCY)enum_).toCurrency());
        }
    }

    public static enum FIAT_CURRENCY {
        UNKNOWN("?"),
        USD("US Dollar"),
        EUR("Euro"),
        JPY("Japanese Yen"),
        GBR("British Pound"),
        CHF("Swiss Franc"),
        CAD("Canadian Dollar"),
        AUD("Australian Dollar"),
        HKD("Hong Kong Dollar"),
        CNY("Chinese Yuan Renminbi"),
        INR("Indian Rupee"),
        RUB("Russian Ruble");

        private String title;
        private String scheme;
        private final CCurrency currency = new CCurrency(this.name(), this.getScheme());

        private FIAT_CURRENCY(String title) {
            this.title = title;
            this.scheme = CCurrency.SCHEME_FIAT_PREFIX + this.name().toLowerCase();
        }

        public CCurrency toCurrency() {
            if (this == UNKNOWN) {
                return null;
            }
            return this.currency;
        }

        public String getTitle() {
            return this.title;
        }

        public String getScheme() {
            return this.scheme;
        }
    }

    public static enum CRYPTO_CURRENCY {
        UNKNOWN("?", ""),
        BTC("Bitcoin", "bitcoin"),
        LTC("Litecoin", "litecoin"),
        NMC("Namecoin", "namecoin"),
        BCH("Bitcoin Cash", "bitcoincash"),
        XRP("Ripple", "ripple"),
        DASH("Dash", "dash"),
        XMR("Monero", "monero"),
        XLM("Stellar", "stellar"),
        ETH("Ethereum", "ethereum"),
        ETC("Ethereum Classic", "ethereumclassic"),
        ZEC("Zcash", "zcash"),
        EOS("EOS.IO", "eos"),
        NEO("NEO", "neo"),
        USDT("USD Tether", "usdtether"),
        EURT("EUR Tether", "eurtether");

        private String title;
        private String scheme;
        private final CCurrency currency = new CCurrency(this.name(), this.getScheme());

        private CRYPTO_CURRENCY(String title, String scheme) {
            this.title = title;
            this.scheme = scheme;
        }

        public CCurrency toCurrency() {
            if (this == UNKNOWN) {
                return null;
            }
            return this.currency;
        }

        public String getTitle() {
            return this.title;
        }

        public String getScheme() {
            return this.scheme;
        }
    }
}

