/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.crypt;

import de.mhus.lib.core.M;
import de.mhus.lib.core.MBigMath;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MMath;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.crypt.Asn1Util;
import de.mhus.lib.core.crypt.AsyncKey;
import de.mhus.lib.core.crypt.CipherBlockAdd;
import de.mhus.lib.core.crypt.CipherBlockRotate;
import de.mhus.lib.core.crypt.CipherDecodeAsync;
import de.mhus.lib.core.crypt.CipherEncodeAsync;
import de.mhus.lib.core.crypt.CipherInputStream;
import de.mhus.lib.core.crypt.CipherOutputStream;
import de.mhus.lib.core.crypt.MRandom;
import de.mhus.lib.core.crypt.SaltInputStream;
import de.mhus.lib.core.crypt.SaltOutputStream;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.errors.MRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.UUID;
import org.apache.commons.codec.Charsets;

public class MCrypt {
    private static Log log = Log.getLog(MCrypt.class);
    private static final int MAX_SPACE = 10;
    private static final int PEPPER_SIZE = 10;

    public static AsyncKey loadPrivateRsaKey(File file) throws IOException {
        String key = MFile.readFile(file);
        return MCrypt.loadPrivateRsaKey(key);
    }

    public static AsyncKey loadPublicRsaKey(File file) throws IOException {
        String key = MFile.readFile(file);
        return MCrypt.loadPublicRsaKey(key);
    }

    public static AsyncKey loadPrivateRsaKey(String key) throws IOException {
        return Asn1Util.loadPrivateRsaKey(key);
    }

    public static AsyncKey loadPublicRsaKey(String key) throws IOException {
        return Asn1Util.loadPublicRsaKey(key);
    }

    public static BigInteger encode(AsyncKey key, BigInteger in) throws IOException {
        if (in.signum() == -1) {
            throw new IOException("Negative values are not allowed");
        }
        BigInteger encoded = MBigMath.binaryPow(in, key.getPublicExponent(), key.getModulus());
        return encoded;
    }

    public static String encodeWithSalt(AsyncKey key, String in) throws IOException {
        byte salt;
        byte[] org = MString.toBytes(in);
        byte[] org2 = new byte[org.length + 1];
        org2[0] = salt = M.l(MRandom.class).getByte();
        for (int i = 0; i < org.length; ++i) {
            org2[i + 1] = MMath.addRotate(org[i], salt);
        }
        BigInteger[] enc = MCrypt.encodeBytes(key, org2);
        String b = MBigMath.toBase91(enc);
        return "A" + b;
    }

    public static String encode(AsyncKey key, String in) throws IOException {
        byte[] org = MString.toBytes(in);
        BigInteger[] enc = MCrypt.encodeBytes(key, org);
        String b = MBigMath.toBase91(enc);
        return b;
    }

    public static BigInteger[] encodeBytes(AsyncKey key, byte[] in) throws IOException {
        CipherEncodeAsync encoder = new CipherEncodeAsync(key, M.l(MRandom.class));
        for (int i = 0; i < in.length; ++i) {
            encoder.write(in[i]);
        }
        encoder.close();
        return encoder.toBigInteger();
    }

    public static BigInteger[] encodeBytes(AsyncKey key, BigInteger[] in) throws IOException {
        BigInteger[] out = new BigInteger[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = MCrypt.encode(key, in[i]);
        }
        return out;
    }

    public static BigInteger decode(AsyncKey key, BigInteger in) throws IOException {
        if (in.signum() == -1) {
            throw new IOException("Negative values not allowed");
        }
        BigInteger decoded = MBigMath.binaryPow(in, key.getPrivateExponent(), key.getModulus());
        return decoded;
    }

    public static String decodeWithSalt(AsyncKey key, String in) throws IOException {
        BigInteger[] benc = MBigMath.fromBase91Array(in.substring(1));
        byte[] enc = MCrypt.decodeBytes(key, benc);
        if (in.charAt(0) == 'A') {
            byte[] enc2 = new byte[enc.length - 1];
            byte salt = enc[0];
            for (int i = 0; i < enc2.length; ++i) {
                enc2[i] = MMath.subRotate(enc[i + 1], salt);
            }
            return MString.toString(enc2);
        }
        throw new IOException("Unknown salt algorithm");
    }

    public static String decode(AsyncKey key, String in) throws IOException {
        BigInteger[] benc = MBigMath.fromBase91Array(in);
        byte[] enc = MCrypt.decodeBytes(key, benc);
        return MString.toString(enc);
    }

    public static BigInteger[] decode(AsyncKey key, BigInteger[] in) throws IOException {
        BigInteger[] out = new BigInteger[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = MCrypt.decode(key, in[i]);
        }
        return out;
    }

    public static byte[] decodeBytes(AsyncKey key, BigInteger[] in) throws IOException {
        CipherDecodeAsync decoder = new CipherDecodeAsync(key);
        for (int i = 0; i < in.length; ++i) {
            decoder.write(in[i]);
        }
        decoder.close();
        return decoder.toBytes();
    }

    public static CipherBlockRotate createRandomCipherBlockRotate(int size) {
        CipherBlockRotate out = new CipherBlockRotate(size);
        byte[] b = out.getBlock();
        for (int i = 0; i < b.length; ++i) {
            b[i] = M.l(MRandom.class).getByte();
        }
        return out;
    }

    public static OutputStream createCipherOutputStream(OutputStream parent, String passphrase) throws IOException {
        return MCrypt.createCipherOutputStream(parent, passphrase, 3);
    }

    public static OutputStream createCipherOutputStream(OutputStream parent, String passphrase, int version) throws IOException {
        if (passphrase == null || passphrase.length() < 1) {
            throw new IOException("passphrase not set");
        }
        if (passphrase.length() < 4) {
            throw new IOException("passphrase smaller then 4");
        }
        byte[] p = MString.toBytes(passphrase);
        if (version < 2 || version > 3) {
            throw new IOException("Cipher version unknown: " + version);
        }
        parent.write(77);
        parent.write(67);
        parent.write(83);
        parent.write(version);
        MRandom random = M.l(MRandom.class);
        if (version == 2) {
            CipherBlockAdd cipher = new CipherBlockAdd(p);
            return new SaltOutputStream(new CipherOutputStream(parent, cipher), random, p.length - random.getInt() % (p.length / 2), true);
        }
        if (version == 3) {
            byte pSalt = random.getByte();
            String md5 = MCrypt.md5(pSalt + passphrase);
            p = MString.toBytes(md5 + passphrase);
            parent.write(MMath.unsignetByteToInt(pSalt));
            CipherBlockAdd cipher = new CipherBlockAdd(p);
            return new SaltOutputStream(new CipherOutputStream(parent, cipher), random, p.length - random.getInt() % (p.length / 2), true);
        }
        throw new IOException("Cipher version unknown: " + version);
    }

    public static InputStream createCipherInputStream(InputStream parent, String passphrase) throws IOException {
        if (passphrase == null || passphrase.length() < 1) {
            throw new IOException("passphrase not set");
        }
        if (passphrase.length() < 4) {
            throw new IOException("passphrase smaller then 4");
        }
        if (parent.read() != 77) {
            throw new IOException("not a crypt stream header");
        }
        if (parent.read() != 67) {
            throw new IOException("not a crypt stream header");
        }
        if (parent.read() != 83) {
            throw new IOException("not a crypt stream header");
        }
        int version = parent.read();
        if (version == 1) {
            int iSalt = parent.read();
            if (iSalt < 0) {
                throw new EOFException();
            }
            byte[] p = MString.toBytes(passphrase);
            byte salt = MMath.subRotate((byte)iSalt, p[0]);
            for (int i = 0; i < p.length; ++i) {
                p[i] = MMath.addRotate(p[i], salt);
            }
            CipherBlockAdd cipher = new CipherBlockAdd(p);
            return new CipherInputStream(parent, cipher);
        }
        if (version == 2) {
            byte[] p = MString.toBytes(passphrase);
            CipherBlockAdd cipher = new CipherBlockAdd(p);
            return new SaltInputStream(new CipherInputStream(parent, cipher), true);
        }
        if (version == 3) {
            byte pSalt = (byte)parent.read();
            String md5 = MCrypt.md5(pSalt + passphrase);
            byte[] p = MString.toBytes(md5 + passphrase);
            CipherBlockAdd cipher = new CipherBlockAdd(p);
            return new SaltInputStream(new CipherInputStream(parent, cipher), true);
        }
        throw new IOException("unsupported crypt stream version: " + version);
    }

    public static byte[] obfuscate(byte[] in) {
        byte salt;
        if (in == null) {
            return null;
        }
        if (in.length < 1) {
            return in;
        }
        byte[] out = new byte[in.length + 1];
        out[0] = salt = M.l(MRandom.class).getByte();
        for (int i = 0; i < in.length; ++i) {
            out[i + 1] = MMath.addRotate(in[i], salt);
        }
        return out;
    }

    public static byte[] unobfuscate(byte[] in) {
        if (in == null) {
            return null;
        }
        if (in.length < 2) {
            return in;
        }
        byte[] out = new byte[in.length - 1];
        byte salt = in[0];
        for (int i = 1; i < in.length; ++i) {
            out[i - 1] = MMath.subRotate(in[i], salt);
        }
        return out;
    }

    public static int getMaxLoad(BigInteger modulus) {
        return modulus.bitLength() / 8;
    }

    public static String md5(String real) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(real.getBytes(Charsets.UTF_8));
            return MCast.toBinaryString(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            log.w(e);
            return null;
        }
    }

    public static String sha256(String text) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(text.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(hash);
        }
        catch (NoSuchAlgorithmException e) {
            log.w(e);
            return null;
        }
    }

    public static String md5WithSalt(String real) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            MRandom rand = M.l(MRandom.class);
            byte[] salt = new byte[]{rand.getByte(), rand.getByte()};
            md.update(salt);
            md.update(real.getBytes(Charsets.UTF_8));
            return MCast.toBinaryString(salt) + MCast.toBinaryString(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            log.w(e);
            return null;
        }
    }

    public static boolean validateMd5WithSalt(String md5, String real) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] salt = MCast.fromBinaryString(md5.substring(0, 4));
            md.update(salt);
            md.update(real.getBytes(Charsets.UTF_8));
            String realMd5 = MCast.toBinaryString(md.digest());
            return realMd5.equals(md5.substring(4));
        }
        catch (Throwable e) {
            log.t(e);
            return false;
        }
    }

    public static byte[] encode(String passphrase, byte[] in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] pp = passphrase.getBytes(Charsets.UTF_8);
        int ppPos = 0;
        MRandom random = M.l(MRandom.class);
        byte salt = random.getByte();
        byte o = MMath.addRotate(salt, pp[ppPos]);
        ppPos = (ppPos + 1) % pp.length;
        out.write(o);
        for (int pos = 0; pos < in.length; ++pos) {
            int space = random.getInt() % 10;
            o = MMath.addRotate((byte)space, pp[ppPos]);
            o = MMath.addRotate(o, salt);
            ppPos = (ppPos + 1) % pp.length;
            out.write(o);
            for (int j = 0; j < space; ++j) {
                out.write(random.getByte());
            }
            o = MMath.addRotate(in[pos], pp[ppPos]);
            o = MMath.addRotate(o, salt);
            ppPos = (ppPos + 1) % pp.length;
            out.write(o);
        }
        int space = random.getInt() % 10;
        o = MMath.addRotate((byte)space, pp[ppPos]);
        o = MMath.addRotate(o, salt);
        ppPos = (ppPos + 1) % pp.length;
        out.write(o);
        for (int j = 0; j < space; ++j) {
            out.write(random.getByte());
        }
        return out.toByteArray();
    }

    public static byte[] decode(String passphrase, byte[] in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] pp = passphrase.getBytes(Charsets.UTF_8);
        int ppPos = 0;
        byte salt = MMath.subRotate(in[0], pp[ppPos]);
        ppPos = (ppPos + 1) % pp.length;
        int mode = 0;
        int space = 0;
        for (int pos = 1; pos < in.length; ++pos) {
            byte o;
            if (mode == 0) {
                o = MMath.subRotate(in[pos], salt);
                space = MMath.subRotate(o, pp[ppPos]);
                ppPos = (ppPos + 1) % pp.length;
                if (space == 0) {
                    mode = 2;
                    continue;
                }
                mode = 1;
                continue;
            }
            if (mode == 1) {
                if ((space = (int)((byte)(space - 1))) > 0) continue;
                mode = 2;
                continue;
            }
            if (mode != 2) continue;
            o = MMath.subRotate(in[pos], salt);
            o = MMath.subRotate(o, pp[ppPos]);
            ppPos = (ppPos + 1) % pp.length;
            out.write(o);
            mode = 0;
        }
        return out.toByteArray();
    }

    public static String addPepper(String content) {
        MRandom rnd = M.l(MRandom.class);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            char c = rnd.getChar();
            if (c == '+') {
                c = 'x';
            }
            sb.append(c);
        }
        sb.append('+');
        sb.append(content);
        return sb.toString();
    }

    public static String removePepper(String withPepper) {
        int p = withPepper.indexOf(43);
        if (p < 0) {
            return withPepper;
        }
        return withPepper.substring(p + 1);
    }

    public static byte[] addPepper(byte[] content) {
        MRandom rnd = M.l(MRandom.class);
        byte[] out = new byte[content.length + 1 + 10];
        for (int i = 0; i < 10; ++i) {
            byte b = rnd.getByte();
            if (b == 0) {
                b = 1;
            }
            out[i] = b;
        }
        out[10] = 0;
        System.arraycopy(content, 0, out, 11, content.length);
        return out;
    }

    public static byte[] removePepper(byte[] withPepper) {
        for (int i = 0; i < withPepper.length; ++i) {
            if (withPepper[i] != 0) continue;
            byte[] out = new byte[withPepper.length - i - 1];
            System.arraycopy(withPepper, i + 1, out, 0, out.length);
            return out;
        }
        byte[] out = new byte[withPepper.length];
        System.arraycopy(withPepper, 0, out, 0, withPepper.length);
        return withPepper;
    }

    public static UUID toUuidHash(String in) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(in.getBytes(Charsets.UTF_8));
            byte[] md5 = md.digest();
            long a = md5[0] * 256 * md5[1] + 65536 * md5[2] + 0x1000000 * md5[3];
            long b = md5[4] * 256 * md5[5] + 65536 * md5[6] + 0x1000000 * md5[7];
            return new UUID(a, b);
        }
        catch (Exception t) {
            throw new MRuntimeException(new Object[]{in, t});
        }
    }
}

