/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.crypt;

import de.mhus.lib.core.MString;
import de.mhus.lib.core.crypt.MRandom;
import de.mhus.lib.core.logging.MLogUtil;
import java.security.SecureRandom;
import java.util.Random;

public class DefaultRandom
implements MRandom {
    private Random rand;
    private SecureRandom secureRandom;

    @Override
    public byte getByte() {
        return (byte)(this.random() * 255.0);
    }

    @Override
    public int getInt() {
        return (int)(this.random() * 2.147483647E9);
    }

    @Override
    public double getDouble() {
        return this.random();
    }

    @Override
    public long getLong() {
        return (long)(this.random() * 9.223372036854776E18);
    }

    protected double random() {
        return Math.random();
    }

    public synchronized Random getRandom() {
        if (this.rand == null) {
            this.rand = new MyRandom();
        }
        return this.rand;
    }

    @Override
    public <T> T adaptTo(Class<? extends T> ifc) {
        if (Random.class.isAssignableFrom(ifc)) {
            return (T)this.getRandom();
        }
        return null;
    }

    @Override
    public char getChar() {
        return MString.CHARS_READABLE[this.getInt() % MString.CHARS_READABLE.length];
    }

    @Override
    public synchronized SecureRandom getSecureRandom() {
        try {
            if (this.secureRandom == null) {
                this.secureRandom = new MySecureRandom();
            }
        }
        catch (Exception e) {
            MLogUtil.log().e(e);
        }
        return this.secureRandom;
    }

    private class MyRandom
    extends Random {
        private static final long serialVersionUID = 1L;

        MyRandom() {
            super(DefaultRandom.this.getLong());
        }

        @Override
        protected int next(int bits) {
            this.setSeed(DefaultRandom.this.getLong());
            return super.next(bits);
        }
    }

    private class MySecureRandom
    extends SecureRandom {
        private static final long serialVersionUID = 1L;

        private MySecureRandom() {
        }

        @Override
        public synchronized void nextBytes(byte[] bytes) {
            super.nextBytes(bytes);
            byte b = DefaultRandom.this.getByte();
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)(bytes[i] + b & 0xFF);
            }
        }
    }
}

