/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.cfg;

import de.mhus.lib.core.AbstractProperties;
import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MPeriod;
import de.mhus.lib.core.cfg.CfgValue;

public class CfgTimeInterval
extends CfgValue<String> {
    private long interval;

    public CfgTimeInterval(Object owner, String path, String def) {
        super(owner, path, def);
    }

    @Override
    protected String loadValue() {
        int p = this.getPath().indexOf(64);
        if (p < 0) {
            return MApi.getCfg(this.getOwner()).getString(this.getPath(), (String)this.getDefault());
        }
        Object node = MApi.getCfg(this.getOwner()).getNodeByPath(this.getPath().substring(0, p));
        if (node == null) {
            return (String)this.getDefault();
        }
        return ((AbstractProperties)node).getString(this.getPath().substring(p + 1), (String)this.getDefault());
    }

    @Override
    protected String loadValue(String value) {
        return value;
    }

    @Override
    void update() {
        String newValue = this.loadValue();
        this.interval = MPeriod.toTime(newValue, -1L);
        if (this.interval == -1L) {
            this.interval = MPeriod.toTime((String)this.getDefault(), -1L);
        }
        super.update();
    }

    public long interval() {
        return this.interval;
    }
}

