/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.IProperties;
import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.logging.Log;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.instrument.Instrumentation;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;

public class MSystem {
    private static Log log = Log.getLog(MSystem.class);
    private static ThreadMXBean tmxb = ManagementFactory.getThreadMXBean();
    private static final Instrumentation instrumentation = ByteBuddyAgent.install();

    public static String getHostname() {
        String out = System.getenv().get("COMPUTERNAME");
        if (out == null) {
            out = System.getenv().get("HOSTNAME");
        }
        if (out == null) {
            RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
            String name = rt.getName();
            out = MString.afterIndex(name, '@');
        }
        return out;
    }

    public static String getPid() {
        RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
        String name = rt.getName();
        return MString.beforeIndex(name, '@');
    }

    public static Properties loadProperties(Object owner, Properties properties, String propertyFile) {
        log.d("Loading properties", propertyFile);
        if (properties == null) {
            properties = new Properties();
        }
        try {
            URL m_url = MSystem.locateResource(owner, propertyFile);
            if (m_url == null) {
                log.w("Properties file not found", propertyFile);
                return properties;
            }
            log.i("load", m_url);
            InputStream stream = m_url.openStream();
            properties.load(stream);
            stream.close();
        }
        catch (IOException e) {
            log.i("Error loading properties file", propertyFile, e.toString());
        }
        return properties;
    }

    public static URL locateResource(Object owner, String fileName) throws IOException {
        File f;
        fileName = MFile.normalize(fileName);
        URL url = null;
        Class<Object> ownerClass = null;
        if (owner != null) {
            ownerClass = owner instanceof Class ? (Class)owner : owner.getClass();
        }
        String qName = ownerClass.getPackage().getName() + "." + fileName;
        String location = System.getProperty(qName + ".file");
        if (url == null && location != null) {
            f = new File(location);
            if (f.exists() && f.isFile()) {
                url = f.toURL();
            } else {
                throw new FileNotFoundException("Configured file not found: " + location + " for " + qName);
            }
        }
        if ((f = MApi.getFile(MApi.SCOPE.ETC, qName)).exists() && f.isFile()) {
            return f.toURL();
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (url == null && loader != null) {
            url = loader.getResource(fileName);
        }
        if (ownerClass != null && url == null) {
            url = ownerClass.getResource("/" + ownerClass.getPackage().getName().replaceAll("\\.", "/") + "/" + fileName);
        }
        if (ownerClass != null && url == null) {
            url = ownerClass.getResource(ownerClass.getPackage().getName().replaceAll("\\.", "/") + "/" + fileName);
        }
        if (url != null) {
            return url;
        }
        throw new FileNotFoundException("Cannot locate resource: " + ownerClass.getPackage().getName() + "/" + fileName);
    }

    public static void beep() {
        System.out.print("\u0007");
        System.out.flush();
    }

    public static String findCalling(int returns) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length > returns) {
            return stack[returns].getClassName();
        }
        return "?";
    }

    public static String findCalling() {
        StackTraceElement[] stack;
        for (StackTraceElement step : stack = Thread.currentThread().getStackTrace()) {
            String n = step.getClassName();
            if (n.startsWith("java.lang") || n.startsWith("de.mhus.lib.core")) continue;
            return n;
        }
        return "?";
    }

    public static String findSourceMethod(int returns) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length > returns) {
            return stack[returns].getMethodName();
        }
        return "?";
    }

    public static String findSourceMethod() {
        StackTraceElement[] stack;
        for (StackTraceElement step : stack = Thread.currentThread().getStackTrace()) {
            String n = step.getClassName();
            if (n.startsWith("java.lang") || n.startsWith("de.mhus.lib.core")) continue;
            return step.getMethodName();
        }
        return "?";
    }

    public static String getMainClassName() {
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            if (!entry.getKey().startsWith("JAVA_MAIN_CLASS")) continue;
            return entry.getValue();
        }
        return null;
    }

    public static String getTmpDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String toString(Object sender, Object ... attributes) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (sender != null) {
            sb.append(sender instanceof String ? sender : sender.getClass().getSimpleName()).append(':');
        }
        boolean first = true;
        for (Object a : attributes) {
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            MString.serialize(sb, a, null);
        }
        sb.append(']');
        return sb.toString();
    }

    public static <A extends Annotation> A findAnnotation(Class<?> clazz, Class<A> annotation) {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            if (!current.isAnnotationPresent(annotation)) continue;
            return current.getAnnotation(annotation);
        }
        return null;
    }

    public static boolean equals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }

    @Deprecated
    public static ScriptResult startScript(File dir, String script, long timeout) {
        log.d("script", dir, script);
        ProcessBuilder pb = new ProcessBuilder(new File(dir, script).getAbsolutePath());
        Map<String, String> env = pb.environment();
        pb.directory(dir);
        ScriptResult out = new ScriptResult();
        try {
            Process p = pb.start();
            BufferedReader os = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader es = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            p.waitFor();
            p.destroy();
            out.output = MFile.readFile(os);
            out.error = MFile.readFile(es);
            out.rc = p.exitValue();
        }
        catch (Throwable t) {
            out.exception = t;
        }
        return out;
    }

    public static String getAppIdent() {
        return MSystem.getHostname() + ":" + MSystem.getPid();
    }

    public static String getObjectId(Object o) {
        if (o == null) {
            return "null";
        }
        String name = o.getClass().getName();
        if (name == null) {
            name = MSystem.getClassName(o);
        }
        return name + "@" + Integer.toHexString(System.identityHashCode(o));
    }

    public static String getClassName(Object obj) {
        Class<?> clazz = MSystem.getMainClass(obj);
        if (clazz == null) {
            return "null";
        }
        return clazz.getCanonicalName();
    }

    public static String getSimpleName(Object obj) {
        Class<?> clazz = MSystem.getMainClass(obj);
        if (clazz == null) {
            return "null";
        }
        return clazz.getSimpleName();
    }

    public static Class<?> getMainClass(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        if (obj instanceof Class) {
            clazz = (Class<?>)obj;
        }
        while (clazz != null && clazz.isAnonymousClass()) {
            clazz = clazz.getEnclosingClass();
        }
        if (clazz == null) {
            return null;
        }
        return clazz;
    }

    public static String getTemplateCanonicalName(Class<?> clazz, int index) {
        Type mySuperclass = clazz.getGenericSuperclass();
        if (mySuperclass instanceof ParameterizedType) {
            Type[] templates = ((ParameterizedType)mySuperclass).getActualTypeArguments();
            if (index >= templates.length) {
                return null;
            }
            Type tType = templates[index];
            String templName = tType.getTypeName();
            return templName;
        }
        return null;
    }

    public static <T extends Comparable<T>> int compareTo(T s1, T s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public static String freeMemoryAsString() {
        long free = MSystem.freeMemory();
        return MString.toByteDisplayString(free);
    }

    public static String maxMemoryAsString() {
        return MString.toByteDisplayString(Runtime.getRuntime().maxMemory());
    }

    public static String memDisplayString() {
        return MSystem.freeMemoryAsString() + " / " + MSystem.maxMemoryAsString();
    }

    public static long freeMemory() {
        Runtime r = Runtime.getRuntime();
        return r.maxMemory() - r.totalMemory() + r.freeMemory();
    }

    public static Field getDeclaredField(Class<?> clazz, String name) {
        if (clazz == null || name == null) {
            return null;
        }
        try {
            Field field = clazz.getDeclaredField(name);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return MSystem.getDeclaredField(clazz.getSuperclass(), name);
        }
    }

    public static Class<?> loadClass(String type, ClassLoader cl) throws ClassNotFoundException {
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if ("int".equals(type)) {
            return Integer.TYPE;
        }
        if ("long".equals(type)) {
            return Long.TYPE;
        }
        if ("short".equals(type)) {
            return Short.TYPE;
        }
        if ("double".equals(type)) {
            return Double.TYPE;
        }
        if ("float".equals(type)) {
            return Float.TYPE;
        }
        if ("byte".equals(type)) {
            return Byte.TYPE;
        }
        if ("boolean".equals(type)) {
            return Boolean.TYPE;
        }
        if ("char".equals(type)) {
            return Character.TYPE;
        }
        if ("String".equals(type)) {
            return String.class;
        }
        if ("Date".equals(type)) {
            return Date.class;
        }
        if ("int[]".equals(type)) {
            return int[].class;
        }
        if ("long[]".equals(type)) {
            return long[].class;
        }
        if ("short[]".equals(type)) {
            return short[].class;
        }
        if ("double[]".equals(type)) {
            return double[].class;
        }
        if ("float[]".equals(type)) {
            return float[].class;
        }
        if ("byte[]".equals(type)) {
            return byte[].class;
        }
        if ("boolean[]".equals(type)) {
            return boolean[].class;
        }
        if ("char[]".equals(type)) {
            return char[].class;
        }
        if ("String[]".equals(type)) {
            return String[].class;
        }
        if ("Date[]".equals(type)) {
            return Date[].class;
        }
        boolean array = false;
        if (type.endsWith("[]")) {
            array = true;
            type = type.substring(0, type.length() - 2);
        }
        Class<?> clazz = cl.loadClass(type);
        if (array) {
            clazz = Array.newInstance(clazz, 0).getClass();
        }
        return clazz;
    }

    public static List<TopThreadInfo> threadTop(long sleep) throws InterruptedException {
        sleep = Math.max(sleep, 200L);
        LinkedList<TopThreadInfo> threads = new LinkedList<TopThreadInfo>();
        for (Map.Entry<Thread, StackTraceElement[]> thread : Thread.getAllStackTraces().entrySet()) {
            threads.add(new TopThreadInfo(tmxb, thread));
        }
        threads.forEach(t -> t.start());
        Thread.sleep(sleep);
        threads.forEach(t -> t.stop());
        long sumCpu = 0L;
        long sumUser = 0L;
        for (TopThreadInfo t2 : threads) {
            sumCpu += t2.getCpuTime();
            sumUser += t2.getUserTime();
        }
        for (TopThreadInfo t2 : threads) {
            t2.setSumTime(sumUser, sumCpu);
        }
        return threads;
    }

    public static ScriptResult execute(String ... command) throws IOException {
        return MSystem.execute(null, null, null, false, command);
    }

    public static ScriptResult execute(IProperties env, File workingDirectory, InputStream stdin, boolean redirectErrorStream, String ... command) throws IOException {
        BufferedReader stdError;
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectErrorStream(redirectErrorStream);
        if (env != null) {
            env.forEach((k, v) -> pb.environment().put((String)k, String.valueOf(v)));
        }
        if (workingDirectory != null) {
            pb.directory(workingDirectory);
        }
        Process proc = pb.start();
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        BufferedReader bufferedReader = stdError = redirectErrorStream ? null : new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        if (stdin != null) {
            BufferedOutputStream bo = new BufferedOutputStream(proc.getOutputStream());
            MFile.copyFile(stdin, bo);
        }
        ScriptResult out = new ScriptResult();
        try {
            proc.waitFor();
        }
        catch (InterruptedException ie) {
            out.exception = ie;
        }
        out.output = MFile.readFile(stdInput);
        if (!redirectErrorStream) {
            out.error = MFile.readFile(stdError);
        }
        out.rc = proc.exitValue();
        return out;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.contains("Windows");
    }

    public static boolean isMac() {
        String os = System.getProperty("os.name");
        return os.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        String os = System.getProperty("os.name");
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") > 0;
    }

    public static boolean isSolaris() {
        String os = System.getProperty("os.name");
        return os.indexOf("sunos") >= 0;
    }

    public static OS getOS() {
        if (MSystem.isWindows()) {
            return OS.WINDOWS;
        }
        if (MSystem.isMac()) {
            return OS.MACOS;
        }
        if (MSystem.isUnix()) {
            return OS.UNIX;
        }
        if (MSystem.isSolaris()) {
            return OS.SOLARIS;
        }
        return OS.OTHER;
    }

    public static File getUserHome() {
        String currentUsersHomeDir = System.getProperty("user.home");
        return new File(currentUsersHomeDir);
    }

    public static String setProperty(String key, String value) {
        if (value == null) {
            return System.clearProperty(key);
        }
        return System.setProperty(key, value);
    }

    public static String getProperty(String key) {
        return System.getProperty(key);
    }

    public static String getProperty(String key, String def) {
        return System.getProperty(key, def);
    }

    public static String getCanonicalClassName(Class<?> clazz) {
        if (clazz.isLocalClass()) {
            return clazz.getCanonicalName();
        }
        if (clazz.isAnonymousClass()) {
            return clazz.getName();
        }
        return clazz.getCanonicalName();
    }

    public static boolean isLockedByThread(Object value) {
        if (value == null) {
            return false;
        }
        int objectHash = value.hashCode();
        for (long threadId : tmxb.getAllThreadIds()) {
            ThreadInfo info = tmxb.getThreadInfo(threadId);
            for (LockInfo locks : info.getLockedSynchronizers()) {
                if (locks.getIdentityHashCode() != objectHash) continue;
                return true;
            }
        }
        return false;
    }

    public static Object getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static byte[] getBytes(Class<?> c) throws IOException {
        ClassFileLocator locator = ClassFileLocator.AgentBased.of(instrumentation, c);
        TypeDescription.ForLoadedType desc = new TypeDescription.ForLoadedType(c);
        ClassFileLocator.Resolution resolution = locator.locate(desc.getName());
        return resolution.resolve();
    }

    public static long getJvmUptime() {
        RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
        long uptime = rb.getUptime();
        return uptime;
    }

    public static long getJvmStartTime() {
        RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
        long uptime = rb.getStartTime();
        return uptime;
    }

    public static long getSystemUptime() {
        try {
            Pattern parse;
            Matcher matcher;
            Process uptimeProc;
            BufferedReader in;
            String line;
            long uptime = -1L;
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("win")) {
                String line2;
                Process uptimeProc2 = Runtime.getRuntime().exec("net stats srv");
                BufferedReader in2 = new BufferedReader(new InputStreamReader(uptimeProc2.getInputStream()));
                while ((line2 = in2.readLine()) != null) {
                    if (!line2.startsWith("Statistics since")) continue;
                    SimpleDateFormat format = new SimpleDateFormat("'Statistics since' MM/dd/yyyy hh:mm:ss a");
                    Date boottime = format.parse(line2);
                    uptime = System.currentTimeMillis() - boottime.getTime();
                    break;
                }
            } else if ((os.contains("mac") || os.contains("nix") || os.contains("nux") || os.contains("aix")) && (line = (in = new BufferedReader(new InputStreamReader((uptimeProc = Runtime.getRuntime().exec("uptime")).getInputStream()))).readLine()) != null && (matcher = (parse = Pattern.compile("((\\d+) days,)? (\\d+):(\\d+)")).matcher(line)).find()) {
                String _days = matcher.group(2);
                String _hours = matcher.group(3);
                String _minutes = matcher.group(4);
                int days = _days != null ? Integer.parseInt(_days) : 0;
                int hours = _hours != null ? Integer.parseInt(_hours) : 0;
                int minutes = _minutes != null ? Integer.parseInt(_minutes) : 0;
                uptime = minutes * 60000 + hours * 60000 * 60 + days * 6000 * 60 * 24;
            }
            return uptime;
        }
        catch (Exception e) {
            log.d(e);
            return -1L;
        }
    }

    public static LinkedList<Method> getMethods(Class<?> clazz) {
        LinkedList<Method> out = new LinkedList<Method>();
        do {
            for (Method m : clazz.getMethods()) {
                out.add(m);
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return out;
    }

    public static LinkedList<Field> getAttributes(Class<?> clazz) {
        LinkedList<Field> out = new LinkedList<Field>();
        do {
            for (Field field : clazz.getDeclaredFields()) {
                out.add(field);
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return out;
    }

    public static Class<?> getClass(ClassLoader cl, String type) throws ClassNotFoundException {
        if (type == null) {
            return null;
        }
        if (type.equals("int") || type.equals("integer")) {
            return Integer.TYPE;
        }
        if (type.equals("bool") || type.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (type.equals("long")) {
            return Long.TYPE;
        }
        if (type.equals("double")) {
            return Double.TYPE;
        }
        if (type.equals("float")) {
            return Float.TYPE;
        }
        if (type.equals("char") || type.equals("character")) {
            return Character.TYPE;
        }
        if (type.equals("short")) {
            return Short.TYPE;
        }
        if (type.equals("byte")) {
            return Byte.TYPE;
        }
        if (type.equals("string") || type.equals("text")) {
            return String.class;
        }
        if (type.equals("date")) {
            return Date.class;
        }
        if (type.equals("map")) {
            return Map.class;
        }
        if (type.equals("list")) {
            return List.class;
        }
        return cl.loadClass(type);
    }

    public static class TopThreadInfo {
        private Thread thread;
        private StackTraceElement[] stacktrace;
        private long startTime;
        private ThreadMXBean tmxb;
        private long startUser;
        private long startCpu;
        private long stopTime;
        private long stopUser;
        private long stopCpu;
        private long diffTime;
        private long diffUser;
        private long diffCpu;
        private double perCpu;
        private double perUser;

        private TopThreadInfo(ThreadMXBean tmxb, Map.Entry<Thread, StackTraceElement[]> thread) {
            this.tmxb = tmxb;
            this.thread = thread.getKey();
            this.stacktrace = thread.getValue();
        }

        private void start() {
            this.startTime = System.currentTimeMillis();
            this.startUser = this.tmxb.getThreadUserTime(this.thread.getId());
            this.startCpu = this.tmxb.getThreadCpuTime(this.thread.getId());
        }

        private void stop() {
            this.stopTime = System.currentTimeMillis();
            this.stopUser = this.tmxb.getThreadUserTime(this.thread.getId());
            this.stopCpu = this.tmxb.getThreadCpuTime(this.thread.getId());
            this.diffTime = this.stopTime - this.startTime;
            this.diffUser = this.stopUser - this.startUser;
            this.diffCpu = this.stopCpu - this.startCpu;
        }

        private void setSumTime(long userTime, long cpuTime) {
            if (cpuTime > 0L) {
                this.perCpu = (double)(this.diffCpu * 100L) / (double)cpuTime;
            }
            if (userTime > 0L) {
                this.perUser = (double)(this.diffUser * 100L) / (double)userTime;
            }
        }

        public long getCpuTime() {
            return this.diffCpu;
        }

        public long getUserTime() {
            return this.diffUser;
        }

        public long getInterval() {
            return this.diffTime;
        }

        public double getCpuPercentage() {
            return this.perCpu;
        }

        public double getUserPercentage() {
            return this.perUser;
        }

        public Thread getThread() {
            return this.thread;
        }

        public StackTraceElement[] getStacktrace() {
            return this.stacktrace;
        }

        public long getCpuTotal() {
            return this.stopCpu;
        }
    }

    public static class ScriptResult {
        private Throwable exception;
        private int rc;
        private String error;
        private String output;

        public String toString() {
            return "[" + this.output + (String)(this.error != null ? "," + this.error : "") + "] " + this.rc;
        }

        public String[] toArray() {
            return new String[]{this.output, this.error};
        }

        public Throwable getException() {
            return this.exception;
        }

        public int getRc() {
            return this.rc;
        }

        public String getError() {
            return this.error;
        }

        public String getOutput() {
            return this.output;
        }
    }

    public static enum OS {
        OTHER,
        UNIX,
        WINDOWS,
        MACOS,
        SOLARIS;

    }
}

