/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.logging.level;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.logging.LevelMapper;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.MLogUtil;

public class ThreadMapperConfig
implements LevelMapper {
    private Log.LEVEL debug = Log.LEVEL.DEBUG;
    private Log.LEVEL error = Log.LEVEL.ERROR;
    private Log.LEVEL fatal = Log.LEVEL.FATAL;
    private Log.LEVEL info = Log.LEVEL.INFO;
    private Log.LEVEL trace = Log.LEVEL.TRACE;
    private Log.LEVEL warn = Log.LEVEL.WARN;
    private boolean local = false;
    private long timeout = 0L;
    private long timetout = 0L;
    private String id = null;

    public boolean isTimedOut() {
        if (this.timetout <= 0L) {
            return false;
        }
        return System.currentTimeMillis() >= this.timetout;
    }

    @Override
    public Log.LEVEL map(Log log, Log.LEVEL level, Object ... msg) {
        switch (level) {
            case DEBUG: {
                return this.debug;
            }
            case ERROR: {
                return this.error;
            }
            case FATAL: {
                return this.fatal;
            }
            case INFO: {
                return this.info;
            }
            case TRACE: {
                return this.trace;
            }
            case WARN: {
                return this.warn;
            }
        }
        return level;
    }

    public void doConfigure(String source, String config) {
        int pos;
        if (config == null) {
            return;
        }
        if ((config = (config = config.trim().toUpperCase()).equals("MAP") ? "" : (config.startsWith("MAP,") ? config.substring(4) : "")).length() > 0 && (pos = config.indexOf(44)) < 0) {
            this.id = config;
            config = "";
        }
        if (source == null) {
            source = "O";
        }
        if ((source = source.toUpperCase()).equals("R")) {
            config = (String)MLogUtil.DEFAULT_TRAIL_REST.value();
        } else if (config.length() == 0) {
            config = source.equals("S") ? (String)MLogUtil.DEFAULT_TRAIL_SHELL.value() : (String)MLogUtil.DEFAULT_TRAIL_CONFIG.value();
        }
        String[] parts = config.toUpperCase().split(",");
        if (parts.length > 0) {
            this.trace = this.toLevel(parts[0]);
        }
        if (parts.length > 1) {
            this.debug = this.toLevel(parts[1]);
        }
        if (parts.length > 2) {
            this.info = this.toLevel(parts[2]);
        }
        if (parts.length > 3) {
            this.warn = this.toLevel(parts[3]);
        }
        if (parts.length > 4) {
            this.error = this.toLevel(parts[4]);
        }
        if (parts.length > 5) {
            this.fatal = this.toLevel(parts[5]);
        }
        if (parts.length > 6) {
            this.local = parts[6].equals("L");
        }
        if (parts.length > 7) {
            this.setTimeout(MCast.tolong(parts[7], 0L));
        }
        if (parts.length > 8) {
            this.id = parts[8];
        }
        if (this.id == null) {
            this.id = source.substring(0, 1) + MLogUtil.createTrailIdent();
        }
        if (this.id.length() > 10) {
            this.id = this.id.substring(0, 10);
        }
    }

    private Log.LEVEL toLevel(String in) {
        switch (in) {
            case "T": {
                return Log.LEVEL.TRACE;
            }
            case "D": {
                return Log.LEVEL.DEBUG;
            }
            case "I": {
                return Log.LEVEL.INFO;
            }
            case "W": {
                return Log.LEVEL.WARN;
            }
            case "E": {
                return Log.LEVEL.ERROR;
            }
            case "F": {
                return Log.LEVEL.FATAL;
            }
        }
        return Log.LEVEL.TRACE;
    }

    public String doSerialize() {
        return "MAP," + this.trace.name().substring(0, 1) + "," + this.debug.name().substring(0, 1) + "," + this.info.name().substring(0, 1) + "," + this.warn.name().substring(0, 1) + "," + this.error.name().substring(0, 1) + "," + this.fatal.name().substring(0, 1) + "," + (this.local ? "L" : "G") + "," + this.timeout + "," + this.id;
    }

    public String toString() {
        return this.doSerialize();
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timetout = timeout <= 0L ? 0L : System.currentTimeMillis() + timeout;
        this.timeout = timeout;
    }

    @Override
    public void prepareMessage(Log log, StringBuilder msg) {
        msg.append('{').append(this.id).append('}');
        msg.append('(').append(Thread.currentThread().getId()).append(')');
    }

    public String getTrailId() {
        return this.id;
    }
}

