/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.MPeriod;
import de.mhus.lib.core.util.MapEntry;
import de.mhus.lib.errors.NotSupportedException;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class SoftTimeoutMap<K, V>
implements Map<K, V> {
    private Map<K, Container<V>> map = new HashMap<K, Container<V>>();
    private long timeout = 600000L;
    private long lastCheck = System.currentTimeMillis();
    private long checkTimeout = 600000L;
    private Invalidator<K, V> invalidator;
    private boolean refreshOnAccess = true;

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        this.doValidationCheck();
        Container<V> ret = this.map.get(key);
        if (ret == null) {
            return null;
        }
        if (ret.isTimeout()) {
            this.remove(ret);
            return null;
        }
        return ret.getValue();
    }

    public long getAccessCount(Object key) {
        this.doValidationCheck();
        Container<V> ret = this.map.get(key);
        return ret == null ? -1L : ret.accessed;
    }

    public synchronized void doValidationCheck() {
        if (MPeriod.isTimeOut(this.lastCheck, this.checkTimeout)) {
            this.map.entrySet().removeIf(e -> this.invalidator != null && this.invalidator.isInvalid(e.getKey(), ((Container)e.getValue()).get(), ((Container)e.getValue()).time, ((Container)e.getValue()).accessed) || ((Container)e.getValue()).isTimeout());
            this.lastCheck = System.currentTimeMillis();
        }
    }

    @Override
    public V put(K key, V value) {
        this.doValidationCheck();
        Container<V> ret = this.map.put(key, new Container<V>(value));
        return ret == null ? null : (V)ret.get();
    }

    @Override
    public V remove(Object key) {
        this.doValidationCheck();
        Container<V> ret = this.map.remove(key);
        return ret == null ? null : (V)ret.get();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        this.doValidationCheck();
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.doValidationCheck();
        HashSet<Map.Entry<K, V>> out = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, Container<V>> entry : this.map.entrySet()) {
            out.add(new MapEntry(entry.getKey(), entry.getValue().get()));
        }
        return out;
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V ret = this.get(key);
        if (ret == null) {
            return defaultValue;
        }
        return ret;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public V replace(K key, V value) {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new NotSupportedException(new Object[0]);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getCheckTimeout() {
        return this.checkTimeout;
    }

    public void setCheckTimeout(long checkTimeout) {
        this.checkTimeout = checkTimeout;
    }

    public Invalidator<K, V> getInvalidator() {
        return this.invalidator;
    }

    public void setInvalidator(Invalidator<K, V> invalidator) {
        this.invalidator = invalidator;
    }

    public boolean isRefreshOnAccess() {
        return this.refreshOnAccess;
    }

    public void setRefreshOnAccess(boolean refreshOnAccess) {
        this.refreshOnAccess = refreshOnAccess;
    }

    public static interface Invalidator<K, V> {
        public boolean isInvalid(K var1, V var2, long var3, long var5);
    }

    private class Container<Z>
    extends SoftReference<Z> {
        long time;
        long accessed;

        public Container(Z value) {
            super(value);
            this.time = System.currentTimeMillis();
            this.accessed = 0L;
        }

        public Z getValue() {
            if (SoftTimeoutMap.this.isRefreshOnAccess()) {
                this.time = System.currentTimeMillis();
            }
            ++this.accessed;
            return (Z)super.get();
        }

        boolean isTimeout() {
            return MPeriod.isTimeOut(this.time, SoftTimeoutMap.this.timeout) || super.get() == null;
        }
    }
}

