/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.basics.ReadOnly;
import java.util.Iterator;

public class ArrayIterator<T>
implements Iterator<T>,
ReadOnly {
    private T[] from;
    private int pos;
    private int max;

    public ArrayIterator(T[] from, int start, int stop) {
        this.from = from;
        this.pos = Math.max(start, 0);
        this.max = Math.min(stop, from.length);
    }

    public ArrayIterator(T[] from) {
        this.from = from;
        this.pos = 0;
        this.max = from.length;
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.max;
    }

    @Override
    public T next() {
        ++this.pos;
        return this.from[this.pos - 1];
    }

    @Override
    public void remove() {
    }
}

