/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.system;

import de.mhus.lib.annotations.activator.DefaultFactory;
import de.mhus.lib.core.MActivator;
import de.mhus.lib.core.MApi;
import de.mhus.lib.core.cfg.CfgInitiator;
import de.mhus.lib.core.cfg.CfgProvider;
import de.mhus.lib.core.config.HashConfig;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.config.XmlConfigFile;
import de.mhus.lib.core.io.FileWatch;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.system.DefaultMApiFactory;
import de.mhus.lib.core.system.IApiInternal;
import de.mhus.lib.core.system.LogCfgInitiator;
import de.mhus.lib.core.system.SystemCfgInitiator;
import de.mhus.lib.core.util.SingleList;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;

@DefaultFactory(value=DefaultMApiFactory.class)
public class CfgManager {
    private HashMap<String, CfgProvider> configurations = new HashMap();
    private CentralMhusCfgProvider provider;
    private IApiInternal internal;
    private IConfig config;
    private FileWatch fileWatch;
    private String configFile;
    private TreeMap<String, Object[]> initiators = new TreeMap();
    private long lastConfigUpdate;

    public CfgManager(IApiInternal internal) {
        this.initiators.put("001_system", new Object[]{new SystemCfgInitiator(), null});
        this.initiators.put("002_logger", new Object[]{new LogCfgInitiator(), null});
        this.internal = internal;
        this.provider = new CentralMhusCfgProvider();
        this.provider.doInitialize();
    }

    public void registerCfgInitiator(String name, CfgInitiator initiator, IConfig config) {
        if (initiator == null) {
            this.initiators.remove(name);
        } else {
            this.initiators.put(name, new Object[]{initiator, config});
        }
    }

    public void registerCfgProvider(String name, CfgProvider provider) {
        if (name == null) {
            return;
        }
        if (provider == null) {
            CfgProvider old = this.configurations.remove(name);
            if (old != null) {
                old.doStop();
            }
        } else {
            this.configurations.put(name, provider);
            provider.doStart(name);
        }
    }

    public String toString() {
        return this.configFile;
    }

    public List<CfgProvider> getProviders() {
        return new SingleList<CfgProvider>(this.provider);
    }

    public IConfig getCfg(Object owner, IConfig def) {
        IConfig cClass;
        String name;
        this.initCfg();
        Class<?> c = null;
        if (owner instanceof String) {
            name = (String)owner;
            cClass = this.getCfg(name);
            if (cClass != null) {
                return cClass;
            }
        } else {
            c = owner instanceof Class ? (Class<?>)owner : owner.getClass();
        }
        while (c != null) {
            name = c.getCanonicalName();
            cClass = this.getCfg(name);
            if (cClass != null) {
                return cClass;
            }
            c = c.getSuperclass();
        }
        return def;
    }

    private void initCfg() {
    }

    public IConfig getCfg(String owner) {
        IConfig cOwner;
        this.initCfg();
        CfgProvider p = this.configurations.get(owner);
        if (p != null && (cOwner = p.getConfig()) != null) {
            return cOwner;
        }
        IConfig defaultConfig = this.provider.getConfig();
        if (defaultConfig == null) {
            return null;
        }
        IConfig cOwner2 = (IConfig)defaultConfig.getNode(owner);
        return cOwner2;
    }

    public IConfig getCfg(String owner, IConfig def) {
        this.initCfg();
        IConfig cClass = this.getCfg(owner);
        if (cClass != null) {
            return cClass;
        }
        return def;
    }

    public void reConfigure() {
        this.provider.reConfigure();
    }

    public List<String> getOwners() {
        this.initCfg();
        return new LinkedList<String>(this.configurations.keySet());
    }

    public long getLastConfigUpdate() {
        return this.lastConfigUpdate;
    }

    class CentralMhusCfgProvider
    implements CfgProvider {
        CentralMhusCfgProvider() {
        }

        public void doInitialize() {
            CfgManager.this.configFile = MApi.get().getSystemProperty("mhus.lib.config.file", "mhus-config.xml");
        }

        public void reConfigure() {
            MApi.dirtyLog("Load mhu-lib configuration");
            try {
                IConfig system = MApi.get().getCfgManager().getCfg("system");
                if (system != null) {
                    MApi.setDirtyTrace(system.getBoolean("log.trace", false));
                    Log.setStacktraceTrace(system.getBoolean("stacktraceTrace", false));
                    MActivator activator = MApi.get().createActivator();
                    for (IConfig node : system.getNodes()) {
                        if (!"initiator".equals(node.getName())) continue;
                        String clazzName = node.getString("class");
                        Object name = node.getString("name", clazzName);
                        String level = node.getString("level", "100");
                        name = level + "_" + (String)name;
                        if ("none".equals(clazzName)) {
                            MApi.dirtyLog("remove initiator", name);
                            CfgManager.this.initiators.remove(name);
                            continue;
                        }
                        if (clazzName == null || CfgManager.this.initiators.containsKey(name)) continue;
                        MApi.dirtyLog("add initiator", name);
                        CfgInitiator initiator = activator.createObject(CfgInitiator.class, clazzName);
                        CfgManager.this.initiators.put((String)name, new Object[]{initiator, node});
                    }
                }
                for (Object[] initiator : CfgManager.this.initiators.values()) {
                    try {
                        CfgInitiator i = (CfgInitiator)initiator[0];
                        IConfig c = (IConfig)initiator[1];
                        MApi.dirtyLog("run initiator", initiator[0].getClass());
                        i.doInitialize(CfgManager.this.internal, MApi.get().getCfgManager(), c);
                    }
                    catch (Throwable t) {
                        MApi.dirtyLog("Can't initiate", initiator.getClass(), " Error: ", t);
                    }
                }
            }
            catch (Throwable t) {
                MApi.dirtyLog("Can't initiate config ", t);
            }
            MApi.getCfgUpdater().doUpdate(null);
        }

        private boolean internalLoadConfig(File file) {
            if (file.exists() && file.isFile()) {
                try {
                    XmlConfigFile c = new XmlConfigFile(file);
                    CfgManager.this.config = c;
                    CfgManager.this.lastConfigUpdate = System.currentTimeMillis();
                    return true;
                }
                catch (Exception e) {
                    MApi.dirtyLog(e);
                }
            }
            MApi.dirtyLog("*** MHUS Config file not found", file);
            return false;
        }

        @Override
        public synchronized IConfig getConfig() {
            if (CfgManager.this.config == null) {
                CfgManager.this.config = new HashConfig();
                if (CfgManager.this.fileWatch != null) {
                    CfgManager.this.fileWatch.doStop();
                    CfgManager.this.fileWatch = null;
                }
                File f = new File(CfgManager.this.configFile);
                MApi.dirtyLog("--- Try to load mhus config from ", f.getAbsolutePath());
                this.internalLoadConfig(f);
                CfgManager.this.fileWatch = new FileWatch(f, new FileWatch.Listener(){

                    @Override
                    public void onFileChanged(FileWatch fileWatch) {
                        File file = fileWatch.getFile();
                        if (CentralMhusCfgProvider.this.internalLoadConfig(file)) {
                            CentralMhusCfgProvider.this.reConfigure();
                        }
                    }

                    @Override
                    public void onFileWatchError(FileWatch fileWatch, Throwable t) {
                        MApi.dirtyLog(t);
                    }
                }).doStart();
            }
            return CfgManager.this.config;
        }

        @Override
        public void doStart(String name) {
        }

        @Override
        public void doStop() {
        }
    }
}

