/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.currency;

import de.mhus.lib.core.MString;
import de.mhus.lib.core.currency.CCurrency;
import de.mhus.lib.core.util.SecureString;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class CAddress
implements Externalizable {
    private static final long serialVersionUID = 1L;
    protected String currency;
    protected String address;
    protected SecureString privKey;
    protected String scheme;

    public CAddress() {
    }

    public CAddress(CCurrency currency, String addr) {
        this.address = addr;
        this.currency = currency.getName();
        this.scheme = currency.getScheme();
    }

    public CAddress(CCurrency currency, String addr, SecureString privKey) {
        this.address = addr;
        this.privKey = privKey;
        this.currency = currency.getName();
        this.scheme = currency.getScheme();
    }

    public CAddress(CCurrency currency, String addr, String privKey) {
        this.address = addr;
        this.privKey = new SecureString(privKey);
        this.currency = currency.getName();
        this.scheme = currency.getScheme();
    }

    public CAddress(String currency, String addr) {
        this.address = addr;
        this.currency = currency.toUpperCase();
        this.scheme = CCurrency.getSchemeForCurrency(this.currency);
    }

    public CAddress(String currency, String addr, SecureString privKey) {
        this.address = addr;
        this.privKey = privKey;
        this.currency = currency.trim().toUpperCase();
        this.scheme = CCurrency.getSchemeForCurrency(this.currency);
    }

    public CAddress(String currency, String addr, String privKey) {
        this.address = addr;
        this.privKey = new SecureString(privKey);
        this.currency = currency.trim().toUpperCase();
        this.scheme = CCurrency.getSchemeForCurrency(this.currency);
    }

    public CAddress(String curAddr) {
        int p = curAddr.indexOf(58);
        this.address = curAddr.substring(p + 1);
        CCurrency c = CCurrency.getCurrenctyForName(curAddr.substring(0, p));
        this.currency = c.getName();
        this.scheme = c.getScheme();
    }

    public final SecureString getPrivate() {
        return this.privKey;
    }

    public final String getAddress() {
        return this.address;
    }

    public final void doSecure() {
        this.privKey = null;
    }

    public final boolean isSecure() {
        return this.privKey == null;
    }

    public String toString() {
        return (MString.isSet(this.scheme) ? this.scheme : this.currency) + ":" + this.address;
    }

    public boolean equals(Object in) {
        if (this.address == null || in == null || !(in instanceof CAddress)) {
            return false;
        }
        return this.address.equals(((CAddress)in).getAddress());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.currency);
        out.writeObject(this.address);
        out.writeObject(this.privKey);
        out.writeObject(this.scheme);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.currency = (String)in.readObject();
        this.address = (String)in.readObject();
        this.privKey = (SecureString)in.readObject();
        this.scheme = (String)in.readObject();
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getAddressWithSchema() {
        return (String)(MString.isSet(this.scheme) ? this.scheme + ":" : "") + this.address;
    }
}

