/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.config;

import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.MXml;
import de.mhus.lib.core.config.DirConfig;
import de.mhus.lib.core.config.HashConfig;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.config.JsonConfig;
import de.mhus.lib.core.config.JsonConfigFile;
import de.mhus.lib.core.config.PropertiesConfig;
import de.mhus.lib.core.config.PropertiesConfigFile;
import de.mhus.lib.core.config.XmlConfig;
import de.mhus.lib.core.config.XmlConfigFile;
import de.mhus.lib.core.lang.IBase;
import de.mhus.lib.core.util.MUri;
import de.mhus.lib.errors.MException;
import de.mhus.lib.errors.NotFoundException;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;

public class MConfig
implements IBase {
    public static IConfig find(String path, boolean include) throws MException {
        File f = new File(path);
        return MConfig.find(f.getParentFile(), f.getName(), include);
    }

    public static IConfig find(File parent, String name, boolean include) throws MException {
        File f = new File(parent, name + ".xml");
        if (f.exists() && f.isFile()) {
            return MConfig.createConfigFor(f, include);
        }
        f = new File(parent, name + ".json");
        if (f.exists() && f.isFile()) {
            return MConfig.createConfigFor(f, include);
        }
        f = new File(parent, name + ".properties");
        if (f.exists() && f.isFile()) {
            return MConfig.createConfigFor(f, include);
        }
        f = new File(parent, name);
        if (f.exists() && f.isDirectory()) {
            return MConfig.createConfigFor(f, include);
        }
        return null;
    }

    public static IConfig createConfigFor(File file) throws MException {
        return MConfig.createConfigFor(file, false);
    }

    public static IConfig createConfigFor(File file, boolean include) throws MException {
        if (include) {
            HashSet<String> included = new HashSet<String>();
            return MConfig.create(file, included);
        }
        return MConfig.create(file);
    }

    protected static IConfig create(File file, HashSet<String> included) throws MException {
        IConfig out = MConfig.create(file);
        included.add(file.getAbsolutePath());
        for (String path : out.getString("__include", "").split(",")) {
            String abs;
            File absolut;
            if (!MString.isSetTrim(path) || (absolut = MFile.getFile(file, path)) == null || included.contains(abs = absolut.getAbsolutePath())) continue;
            IConfig nextOne = MConfig.create(absolut, included);
            for (String key : nextOne.getPropertyKeys()) {
                if (out.containsKey(key)) continue;
                out.setProperty(key, nextOne.get(key));
            }
            included.add(abs);
        }
        return out;
    }

    public static IConfig create(File file) throws MException {
        if (file.isDirectory()) {
            return new DirConfig(file);
        }
        String key = file.getName();
        if (key.endsWith(".xml")) {
            try {
                XmlConfigFile out = new XmlConfigFile(file);
                out.setName(MFile.getFileNameOnly(key));
                out.setString("__path", file.getAbsolutePath());
                return out;
            }
            catch (Exception e) {
                throw new MException(new Object[]{file, e});
            }
        }
        if (key.endsWith(".properties")) {
            try {
                PropertiesConfigFile out = new PropertiesConfigFile(file);
                out.setName(MFile.getFileNameOnly(key));
                out.setString("__path", file.getAbsolutePath());
                return out;
            }
            catch (Exception e) {
                throw new MException(new Object[]{file, e});
            }
        }
        if (key.endsWith(".json")) {
            try {
                JsonConfigFile out = new JsonConfigFile(file);
                out.setName(MFile.getFileNameOnly(key));
                out.setString("__path", file.getAbsolutePath());
                return out;
            }
            catch (Exception e) {
                throw new MException(new Object[]{file, e});
            }
        }
        return null;
    }

    public static IConfig createConfigFor(URI uri) throws MException {
        if (uri == null) {
            return null;
        }
        String key = uri.getPath();
        if (key == null) {
            key = uri.toString();
        }
        if (key.endsWith(".xml")) {
            try {
                XmlConfigFile out = new XmlConfigFile(uri.toURL().openStream());
                out.setName(MFile.getFileNameOnly(key));
                out.setString("__path", uri.getPath());
                out.setString("__host", uri.getHost());
                out.setInt("__port", uri.getPort());
                out.setString("__user", uri.getUserInfo());
                return out;
            }
            catch (Exception e) {
                throw new MException(new Object[]{uri, e});
            }
        }
        if (key.endsWith(".properties")) {
            try {
                PropertiesConfigFile out = new PropertiesConfigFile(uri.toURL().openStream());
                out.setName(MFile.getFileNameOnly(key));
                out.setString("__path", uri.getPath());
                out.setString("__host", uri.getHost());
                out.setInt("__port", uri.getPort());
                out.setString("__user", uri.getUserInfo());
                return out;
            }
            catch (Exception e) {
                throw new MException(new Object[]{uri, e});
            }
        }
        if (key.endsWith(".json")) {
            try {
                JsonConfigFile out = new JsonConfigFile(uri.toURL().openStream());
                out.setName(MFile.getFileNameOnly(key));
                out.setString("__path", uri.getPath());
                out.setString("__host", uri.getHost());
                out.setInt("__port", uri.getPort());
                out.setString("__user", uri.getUserInfo());
                return out;
            }
            catch (Exception e) {
                throw new MException(new Object[]{uri, e});
            }
        }
        return null;
    }

    public static IConfig createConfigForFile(String key) throws MException {
        if (key == null) {
            return null;
        }
        if (key.endsWith(".xml")) {
            return new XmlConfig();
        }
        if (key.endsWith(".properties")) {
            return new PropertiesConfig();
        }
        if (key.endsWith(".json")) {
            try {
                return new JsonConfig();
            }
            catch (Exception e) {
                throw new MException(new Object[]{key, e});
            }
        }
        return null;
    }

    public static IConfig toConfig(String configString) throws MException {
        if (MString.isEmptyTrim(configString)) {
            return new HashConfig();
        }
        if (configString.startsWith("[") || configString.startsWith("{")) {
            try {
                return new JsonConfig(configString);
            }
            catch (Exception e) {
                throw new MException(new Object[]{configString, e});
            }
        }
        if (configString.startsWith("<?")) {
            try {
                return new XmlConfig(MXml.loadXml(configString).getDocumentElement());
            }
            catch (Exception e) {
                throw new MException(new Object[]{configString, e});
            }
        }
        if (configString.contains("=")) {
            if (configString.contains("&")) {
                return new HashConfig(MUri.explode(configString));
            }
            return new PropertiesConfig(configString);
        }
        return null;
    }

    public static String[] toStringArray(Collection<IConfig> nodes, String key) {
        LinkedList<String> out = new LinkedList<String>();
        for (IConfig item : nodes) {
            String value = item.getString(key, null);
            if (value == null) continue;
            out.add(value);
        }
        return out.toArray(new String[out.size()]);
    }

    public static IConfig createFromResource(Class<?> owner, String fileName) throws MException {
        try {
            URL url = MSystem.locateResource(owner, fileName);
            if (fileName.endsWith(".xml")) {
                return new XmlConfigFile(url.openStream());
            }
            if (fileName.endsWith(".properties")) {
                return new PropertiesConfigFile(url.openStream());
            }
            if (fileName.endsWith(".json")) {
                return new JsonConfigFile(url.openStream());
            }
        }
        catch (Throwable t) {
            throw new MException(new Object[]{fileName, t});
        }
        throw new NotFoundException(new Object[]{fileName});
    }
}

