/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.logging;

import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.core.logging.LogEngine;
import de.mhus.lib.core.logging.LogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JFactory
extends LogFactory {
    @Override
    public LogEngine createInstance(String name) {
        return new SLF4JLog(LoggerFactory.getLogger((String)name));
    }

    @Override
    public void init(ResourceNode<?> config) throws Exception {
    }

    private class SLF4JLog
    extends LogEngine {
        private Logger logger;

        private SLF4JLog(Logger logger) {
            super(logger.getName());
            this.logger = logger;
        }

        @Override
        public void trace(Object message) {
            this.getLogger().trace(String.valueOf(message));
        }

        @Override
        public void trace(Object message, Throwable t) {
            this.getLogger().trace(String.valueOf(message), t);
        }

        @Override
        public void debug(Object message) {
            this.getLogger().debug(String.valueOf(message));
        }

        @Override
        public void debug(Object message, Throwable t) {
            this.getLogger().debug(String.valueOf(message), t);
        }

        @Override
        public void info(Object message) {
            this.getLogger().info(String.valueOf(message));
        }

        @Override
        public void info(Object message, Throwable t) {
            this.getLogger().info(String.valueOf(message), t);
        }

        @Override
        public void warn(Object message) {
            this.getLogger().warn(String.valueOf(message));
        }

        @Override
        public void warn(Object message, Throwable t) {
            this.getLogger().warn(String.valueOf(message), t);
        }

        @Override
        public void error(Object message) {
            this.getLogger().error(String.valueOf(message));
        }

        @Override
        public void error(Object message, Throwable t) {
            this.getLogger().error(String.valueOf(message), t);
        }

        @Override
        public void fatal(Object message) {
            this.getLogger().error(String.valueOf(message));
        }

        @Override
        public void fatal(Object message, Throwable t) {
            this.getLogger().error(String.valueOf(message), t);
        }

        public Logger getLogger() {
            if (this.logger == null) {
                this.logger = LoggerFactory.getLogger((String)this.getName());
            }
            return this.logger;
        }

        @Override
        public boolean isDebugEnabled() {
            return this.getLogger().isDebugEnabled();
        }

        @Override
        public boolean isErrorEnabled() {
            return this.getLogger().isErrorEnabled();
        }

        @Override
        public boolean isFatalEnabled() {
            return this.logger.isErrorEnabled();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.getLogger().isInfoEnabled();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.getLogger().isTraceEnabled();
        }

        @Override
        public boolean isWarnEnabled() {
            return this.getLogger().isWarnEnabled();
        }

        @Override
        public void doInitialize(LogFactory logFactory) {
        }

        @Override
        public void close() {
        }
    }
}

