/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.util.VersionRange;

public class Version
implements Comparable<Version> {
    public static final Version V_0_0_0 = new Version("0.0.0");
    public static final Version V_1_0_0 = new Version("1.0.0");
    private String original;
    private long[] versions;
    private VersionRange range;

    public Version(String in) {
        if (in == null) {
            in = "0.0.0";
        }
        this.original = in;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == '.' || c >= '0' && c <= '9') continue;
            in = in.substring(0, i);
            break;
        }
        String[] parts = in.split("\\.");
        this.versions = new long[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            this.versions[i] = MCast.tolong(parts[i], 0L);
        }
    }

    public int size() {
        if (this.versions == null) {
            return 0;
        }
        return this.versions.length;
    }

    public long getVersion(int index) {
        return this.versions[index];
    }

    public String toString() {
        return MString.join(this.versions, '.');
    }

    public boolean equals(Object in) {
        if (in == null) {
            return false;
        }
        if (in instanceof String) {
            in = new Version((String)in);
        }
        if (in instanceof Version) {
            Version v = (Version)in;
            if (v.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (v.getVersion(i) == this.getVersion(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(Version o) {
        int len = Math.min(this.size(), o.size());
        for (int i = 0; i < len; ++i) {
            long v;
            long ov = o.getVersion(i);
            if (ov < (v = this.getVersion(i))) {
                return 1;
            }
            if (ov <= v) continue;
            return -1;
        }
        if (this.size() > len) {
            return 1;
        }
        if (o.size() > len) {
            return -1;
        }
        return 0;
    }

    public VersionRange toRange() {
        if (this.range == null) {
            this.range = new VersionRange(this.toString());
        }
        return this.range;
    }

    public String getOriginal() {
        return this.original;
    }
}

