/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.strategy;

import de.mhus.lib.basics.Versioned;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.definition.DefRoot;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.strategy.Operation;
import de.mhus.lib.core.strategy.OperationGroupDescription;
import de.mhus.lib.core.util.MNls;
import de.mhus.lib.core.util.MNlsProvider;
import de.mhus.lib.core.util.Nls;
import de.mhus.lib.core.util.ParameterDefinitions;
import de.mhus.lib.core.util.Version;
import java.util.HashMap;
import java.util.UUID;

public class OperationDescription
implements MNlsProvider,
Nls,
Versioned {
    public static final String TAGS = "tags";
    private static Log log = Log.getLog(OperationDescription.class);
    private String id;
    private String title;
    private String group;
    private DefRoot form;
    private HashMap<String, String> parameters;
    private ParameterDefinitions parameterDef;
    private MNls nls;
    private MNlsProvider nlsProvider;
    private Version version;
    private UUID uuid;

    public OperationDescription() {
    }

    public OperationDescription(UUID uuid, Class<?> clazz, MNlsProvider nlsProvider, String version, String title) {
        this(uuid, clazz, nlsProvider, new Version(version), title, null);
    }

    public OperationDescription(UUID uuid, Class<?> clazz, MNlsProvider nlsProvider, Version version, String title) {
        this(uuid, clazz, nlsProvider, version, title, null);
    }

    public OperationDescription(UUID uuid, Class<?> clazz, MNlsProvider nlsProvider, String title) {
        this(uuid, clazz, nlsProvider, new Version(null), title, null);
    }

    public OperationDescription(Operation owner, Version version, String title, DefRoot form) {
        this(owner.getUuid(), owner.getClass(), owner, version, title, form);
    }

    public OperationDescription(Operation owner, String title, DefRoot form) {
        this(owner.getUuid(), owner.getClass(), owner, new Version(null), title, form);
    }

    public OperationDescription(Operation owner, String group, String id, String title, DefRoot form) {
        this(owner.getUuid(), group, id, new Version(null), owner, title, form);
    }

    public OperationDescription(UUID uuid, Class<?> clazz, MNlsProvider nlsProvider, Version version, String title, DefRoot form) {
        this(uuid, clazz.getPackage().getName(), clazz.getSimpleName(), version, nlsProvider, title, form);
    }

    public void setForm(DefRoot form) {
        if (form == null) {
            this.form = null;
            this.parameterDef = null;
            return;
        }
        try {
            form = form.build();
            this.parameterDef = ParameterDefinitions.create(form);
            this.form = form;
        }
        catch (Exception e) {
            log.w("invalid form", this.group, this.id, this.version, e);
        }
    }

    public ParameterDefinitions getParameterDefinitions() {
        return this.parameterDef;
    }

    public OperationDescription(UUID uuid, OperationGroupDescription group, String id, Version version, MNlsProvider nlsProvider, String title) {
        this(uuid, group.getGroup(), id, version, nlsProvider, title, null);
    }

    public OperationDescription(UUID uuid, String group, String id, Version version, MNlsProvider nlsProvider, String title) {
        this(uuid, group, id, version, nlsProvider, title, null);
    }

    public OperationDescription(UUID uuid, String group, String id, Version version, MNlsProvider nlsProvider, String title, DefRoot form) {
        this.uuid = uuid;
        this.id = id;
        this.group = group;
        this.nlsProvider = nlsProvider;
        this.title = title;
        this.version = version;
        if (form != null) {
            this.setForm(form);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getGroup() {
        return this.group;
    }

    public DefRoot getForm() {
        return this.form;
    }

    public String getPath() {
        return this.group + "." + this.id;
    }

    public String getVersionString() {
        return this.version.toString();
    }

    public Version getVersion() {
        return this.version;
    }

    public HashMap<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(HashMap<String, String> parameters) {
        this.parameters = parameters;
    }

    public OperationDescription putParameter(String key, String value) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.parameters.put(key, value);
        return this;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof OperationDescription) {
            OperationDescription od = (OperationDescription)o;
            return MSystem.equals(this.group, od.group) && MSystem.equals(this.id, od.id);
        }
        return super.equals(o);
    }

    public String toString() {
        return MSystem.toString(this, this.group, this.id, this.parameters);
    }

    @Override
    public MNls getNls() {
        if (this.nls == null) {
            this.nls = this.nlsProvider.getNls();
        }
        return this.nls;
    }

    @Override
    public String nls(String text) {
        return MNls.find(this, text);
    }

    public String getCaption() {
        return this.nls("caption=" + this.getTitle());
    }

    public UUID getUuid() {
        return this.uuid;
    }
}

