/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.currency;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class CCurrency
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private String name;

    public CCurrency(String in) {
        if (in == null) {
            throw new NullPointerException("Currency name can't be null");
        }
        this.name = in.trim().toUpperCase();
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object in) {
        if (in == null) {
            return false;
        }
        return this.name.equals(in.toString());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
    }

    public CRYPTO_CURRENCY toCryptoCurrency() {
        try {
            return CRYPTO_CURRENCY.valueOf(this.name);
        }
        catch (IllegalArgumentException e) {
            return CRYPTO_CURRENCY.UNKNOWN;
        }
    }

    public FIAT_CURRENCY toFiatCurrency() {
        try {
            return FIAT_CURRENCY.valueOf(this.name);
        }
        catch (IllegalArgumentException e) {
            return FIAT_CURRENCY.UNKNOWN;
        }
    }

    public static enum FIAT_CURRENCY {
        UNKNOWN("?"),
        USD("US Dollar"),
        EUR("Euro"),
        JPY("Japanese Yen"),
        GBR("British Pound"),
        CHF("Swiss Franc"),
        CAD("Canadian Dollar"),
        AUD("Australian Dollar"),
        HKD("Hong Kong Dollar"),
        CNY("Chinese Yuan Renminbi"),
        INR("Indian Rupee"),
        RUB("Russian Ruble");

        private String title;
        private final CCurrency currency = new CCurrency(this.name());

        private FIAT_CURRENCY(String title) {
            this.title = title;
        }

        public CCurrency toCurrency() {
            if (this == UNKNOWN) {
                return null;
            }
            return this.currency;
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static enum CRYPTO_CURRENCY {
        UNKNOWN("?"),
        BTC("Bitcoin"),
        LTC("Litecoin"),
        NMC("Namecoin"),
        BCH("Bitcoin Cash"),
        XRP("Ripple"),
        DASH("Dash"),
        XMR("Monero"),
        XLM("Stellar"),
        ETH("Ethereum"),
        ETC("Ethereum Classic"),
        ZEC("Zcash"),
        EOS("EOS.IO"),
        NEO("NEO"),
        USDT("USD Tether"),
        EURT("EUR Tether");

        private String title;
        private final CCurrency currency = new CCurrency(this.name());

        private CRYPTO_CURRENCY(String title) {
            this.title = title;
        }

        public CCurrency toCurrency() {
            if (this == UNKNOWN) {
                return null;
            }
            return this.currency;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

