/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.config;

import de.mhus.lib.core.MXml;
import de.mhus.lib.core.config.XmlConfig;
import de.mhus.lib.errors.MException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.w3c.dom.Node;

public class XmlConfigFile
extends XmlConfig {
    private static final long serialVersionUID = 1L;
    private File file;

    public XmlConfigFile(File file) throws FileNotFoundException, Exception {
        if (file.exists()) {
            this.readConfig(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        }
        this.file = file;
    }

    public XmlConfigFile(InputStream is) throws FileNotFoundException, Exception {
        this.readConfig(new InputStreamReader(is, "UTF-8"));
        this.file = null;
    }

    public boolean canSave() {
        if (this.file == null) {
            return false;
        }
        if (!this.file.exists()) {
            return this.file.getParentFile().canWrite();
        }
        return this.file.canWrite();
    }

    public void save() throws MException {
        try {
            if (!this.canSave()) {
                return;
            }
            this.log().t("save config", this);
            FileOutputStream os = new FileOutputStream(this.file);
            MXml.trim(this.element);
            MXml.saveXml((Node)this.element, os);
            os.close();
        }
        catch (Exception e) {
            throw new MException(new Object[]{e});
        }
    }

    @Override
    public String toString() {
        return this.getClass() + ": " + (this.file == null ? "?" : this.file.getAbsolutePath());
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getFile() {
        return this.file;
    }
}

